/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.session;

import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.http.session.IdGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class StandardIdGenerator
implements IdGenerator {
    private static final int ID_LENGTH = 30;
    private SecureRandom mRandom = this.createSecureRandom();

    @Override
    @NonNull
    public String generateId() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder(80);
        int resultLenBytes = 0;
        while (resultLenBytes < 30) {
            this.mRandom.nextBytes(random);
            for (int j = 0; j < random.length && resultLenBytes < 30; ++resultLenBytes, ++j) {
                byte b1 = (byte)((random[j] & 0xF0) >> 4);
                byte b2 = (byte)(random[j] & 0xF);
                if (b1 < 10) {
                    buffer.append((char)(48 + b1));
                } else {
                    buffer.append((char)(65 + (b1 - 10)));
                }
                if (b2 < 10) {
                    buffer.append((char)(48 + b2));
                    continue;
                }
                buffer.append((char)(65 + (b2 - 10)));
            }
        }
        return buffer.toString();
    }

    private SecureRandom createSecureRandom() {
        SecureRandom result;
        try {
            result = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            result = new SecureRandom();
        }
        result.nextInt();
        return result;
    }
}

