/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework;

import android.util.Log;
import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.framework.HandlerInterceptor;
import com.yanzhenjie.andserver.framework.handler.RequestHandler;
import com.yanzhenjie.andserver.http.HttpMethod;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.http.Modified;

public class ModifiedInterceptor
implements HandlerInterceptor {
    @Override
    public boolean onIntercept(@NonNull HttpRequest request, @NonNull HttpResponse response, @NonNull RequestHandler handler) {
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.GET || method == HttpMethod.HEAD) {
            String eTag = null;
            try {
                eTag = handler.getETag(request);
            }
            catch (Throwable e) {
                Log.w((String)"AndServer", (Throwable)e);
            }
            long lastModified = -1L;
            try {
                lastModified = handler.getLastModified(request);
            }
            catch (Throwable e) {
                Log.w((String)"AndServer", (Throwable)e);
            }
            return new Modified(request, response).process(eTag, lastModified);
        }
        return false;
    }
}

