/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yalantis.ucrop.R;
import com.yalantis.ucrop.callback.CropBoundsChangeListener;
import com.yalantis.ucrop.callback.OverlayViewChangeListener;
import com.yalantis.ucrop.view.GestureCropImageView;
import com.yalantis.ucrop.view.OverlayView;

public class UCropView
extends FrameLayout {
    private final GestureCropImageView mGestureCropImageView;
    private final OverlayView mViewOverlay;

    public UCropView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UCropView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ucrop_view, (ViewGroup)this, true);
        this.mGestureCropImageView = (GestureCropImageView)this.findViewById(R.id.image_view_crop);
        this.mViewOverlay = (OverlayView)this.findViewById(R.id.view_overlay);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ucrop_UCropView);
        this.mViewOverlay.processStyledAttributes(a);
        this.mGestureCropImageView.processStyledAttributes(a);
        a.recycle();
        this.mGestureCropImageView.setCropBoundsChangeListener(new CropBoundsChangeListener(){

            @Override
            public void onCropAspectRatioChanged(float cropRatio) {
                UCropView.this.mViewOverlay.setTargetAspectRatio(cropRatio);
            }
        });
        this.mViewOverlay.setOverlayViewChangeListener(new OverlayViewChangeListener(){

            @Override
            public void onCropRectUpdated(RectF cropRect) {
                UCropView.this.mGestureCropImageView.setCropRect(cropRect);
            }
        });
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @NonNull
    public GestureCropImageView getCropImageView() {
        return this.mGestureCropImageView;
    }

    @NonNull
    public OverlayView getOverlayView() {
        return this.mViewOverlay;
    }
}

