/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.phoenix.util;

import android.text.TextUtils;
import android.util.Log;

public final class Logger {
    private static final String TAG = "Phoenix";
    private static boolean logEnabled_d = false;
    private static boolean logEnabled_i = false;
    private static boolean logEnabled_e = false;

    public static void d() {
        if (logEnabled_d) {
            Log.v((String)TAG, (String)Logger.getLocation());
        }
    }

    public static void d(String msg) {
        if (logEnabled_d) {
            Log.v((String)TAG, (String)(Logger.getLocation() + msg));
        }
    }

    public static void i(String msg) {
        if (logEnabled_i) {
            Log.i((String)TAG, (String)(Logger.getLocation() + msg));
        }
    }

    public static void i() {
        if (logEnabled_i) {
            Log.i((String)TAG, (String)Logger.getLocation());
        }
    }

    public static void e(String msg) {
        if (logEnabled_e) {
            Log.e((String)TAG, (String)(Logger.getLocation() + msg));
        }
    }

    public static void e(String msg, Throwable e) {
        if (logEnabled_e) {
            Log.e((String)TAG, (String)(Logger.getLocation() + msg), (Throwable)e);
        }
    }

    public static void e(Throwable e) {
        if (logEnabled_e) {
            Log.e((String)TAG, (String)Logger.getLocation(), (Throwable)e);
        }
    }

    public static void e() {
        if (logEnabled_e) {
            Log.e((String)TAG, (String)Logger.getLocation());
        }
    }

    private static String getLocation() {
        String className = Logger.class.getName();
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        boolean found = false;
        for (StackTraceElement trace : traces) {
            try {
                if (found) {
                    if (trace.getClassName().startsWith(className)) continue;
                    Class<?> clazz = Class.forName(trace.getClassName());
                    return "[" + Logger.getClassName(clazz) + ":" + trace.getMethodName() + ":" + trace.getLineNumber() + "]: ";
                }
                if (!trace.getClassName().startsWith(className)) continue;
                found = true;
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return "[]: ";
    }

    private static String getClassName(Class<?> clazz) {
        if (clazz != null) {
            if (!TextUtils.isEmpty((CharSequence)clazz.getSimpleName())) {
                return clazz.getSimpleName();
            }
            return Logger.getClassName(clazz.getEnclosingClass());
        }
        return "";
    }
}

