/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.phoenix.refresh_view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import com.yalantis.phoenix.PullToRefreshView;
import com.yalantis.phoenix.R;
import com.yalantis.phoenix.refresh_view.BaseRefreshView;
import com.yalantis.phoenix.util.Utils;

public class SunRefreshView
extends BaseRefreshView
implements Animatable {
    private static final float SCALE_START_PERCENT = 0.5f;
    private static final int ANIMATION_DURATION = 1000;
    private static final float SKY_RATIO = 0.65f;
    private static final float SKY_INITIAL_SCALE = 1.05f;
    private static final float TOWN_RATIO = 0.22f;
    private static final float TOWN_INITIAL_SCALE = 1.2f;
    private static final float TOWN_FINAL_SCALE = 1.3f;
    private static final float SUN_FINAL_SCALE = 0.75f;
    private static final float SUN_INITIAL_ROTATE_GROWTH = 1.2f;
    private static final float SUN_FINAL_ROTATE_GROWTH = 1.5f;
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private PullToRefreshView mParent;
    private Matrix mMatrix;
    private Animation mAnimation;
    private int mTop;
    private int mScreenWidth;
    private int mSkyHeight;
    private float mSkyTopOffset;
    private float mSkyMoveOffset;
    private int mTownHeight;
    private float mTownInitialTopOffset;
    private float mTownFinalTopOffset;
    private float mTownMoveOffset;
    private int mSunSize = 100;
    private float mSunLeftOffset;
    private float mSunTopOffset;
    private float mPercent = 0.0f;
    private float mRotate = 0.0f;
    private Bitmap mSky;
    private Bitmap mSun;
    private Bitmap mTown;
    private boolean isRefreshing = false;

    public SunRefreshView(Context context, final PullToRefreshView parent) {
        super(context, parent);
        this.mParent = parent;
        this.mMatrix = new Matrix();
        this.setupAnimations();
        parent.post(new Runnable(){

            @Override
            public void run() {
                SunRefreshView.this.initiateDimens(parent.getWidth());
            }
        });
    }

    public void initiateDimens(int viewWidth) {
        if (viewWidth <= 0 || viewWidth == this.mScreenWidth) {
            return;
        }
        this.mScreenWidth = viewWidth;
        this.mSkyHeight = (int)(0.65f * (float)this.mScreenWidth);
        this.mSkyTopOffset = (float)this.mSkyHeight * 0.38f;
        this.mSkyMoveOffset = Utils.convertDpToPixel(this.getContext(), 15);
        this.mTownHeight = (int)(0.22f * (float)this.mScreenWidth);
        this.mTownInitialTopOffset = (float)this.mParent.getTotalDragDistance() - (float)this.mTownHeight * 1.2f;
        this.mTownFinalTopOffset = (float)this.mParent.getTotalDragDistance() - (float)this.mTownHeight * 1.3f;
        this.mTownMoveOffset = Utils.convertDpToPixel(this.getContext(), 10);
        this.mSunLeftOffset = 0.3f * (float)this.mScreenWidth;
        this.mSunTopOffset = (float)this.mParent.getTotalDragDistance() * 0.1f;
        this.mTop = -this.mParent.getTotalDragDistance();
        this.createBitmaps();
    }

    private void createBitmaps() {
        this.mSky = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.sky);
        this.mSky = Bitmap.createScaledBitmap((Bitmap)this.mSky, (int)this.mScreenWidth, (int)this.mSkyHeight, (boolean)true);
        this.mTown = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.buildings);
        this.mTown = Bitmap.createScaledBitmap((Bitmap)this.mTown, (int)this.mScreenWidth, (int)((int)((float)this.mScreenWidth * 0.22f)), (boolean)true);
        this.mSun = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.sun);
        this.mSun = Bitmap.createScaledBitmap((Bitmap)this.mSun, (int)this.mSunSize, (int)this.mSunSize, (boolean)true);
    }

    @Override
    public void setPercent(float percent, boolean invalidate) {
        this.setPercent(percent);
        if (invalidate) {
            this.setRotate(percent);
        }
    }

    @Override
    public void offsetTopAndBottom(int offset) {
        this.mTop += offset;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.mScreenWidth <= 0) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate(0.0f, (float)this.mTop);
        canvas.clipRect(0, -this.mTop, this.mScreenWidth, this.mParent.getTotalDragDistance());
        this.drawSky(canvas);
        this.drawSun(canvas);
        this.drawTown(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void drawSky(Canvas canvas) {
        float skyScale;
        Matrix matrix = this.mMatrix;
        matrix.reset();
        float dragPercent = Math.min(1.0f, Math.abs(this.mPercent));
        float scalePercentDelta = dragPercent - 0.5f;
        if (scalePercentDelta > 0.0f) {
            float scalePercent = scalePercentDelta / 0.5f;
            skyScale = 1.05f - 0.049999952f * scalePercent;
        } else {
            skyScale = 1.05f;
        }
        float offsetX = -((float)this.mScreenWidth * skyScale - (float)this.mScreenWidth) / 2.0f;
        float offsetY = (1.0f - dragPercent) * (float)this.mParent.getTotalDragDistance() - this.mSkyTopOffset - (float)this.mSkyHeight * (skyScale - 1.0f) / 2.0f + this.mSkyMoveOffset * dragPercent;
        matrix.postScale(skyScale, skyScale);
        matrix.postTranslate(offsetX, offsetY);
        canvas.drawBitmap(this.mSky, matrix, null);
    }

    private void drawTown(Canvas canvas) {
        float townMoveOffset;
        float townTopOffset;
        float townScale;
        float scalePercent;
        Matrix matrix = this.mMatrix;
        matrix.reset();
        float dragPercent = Math.min(1.0f, Math.abs(this.mPercent));
        float scalePercentDelta = dragPercent - 0.5f;
        if (scalePercentDelta > 0.0f) {
            scalePercent = scalePercentDelta / 0.5f;
            townScale = 1.2f + 0.099999905f * scalePercent;
            townTopOffset = this.mTownInitialTopOffset - (this.mTownFinalTopOffset - this.mTownInitialTopOffset) * scalePercent;
            townMoveOffset = this.mTownMoveOffset * (1.0f - scalePercent);
        } else {
            scalePercent = dragPercent / 0.5f;
            townScale = 1.2f;
            townTopOffset = this.mTownInitialTopOffset;
            townMoveOffset = this.mTownMoveOffset * scalePercent;
        }
        float offsetX = -((float)this.mScreenWidth * townScale - (float)this.mScreenWidth) / 2.0f;
        float offsetY = (1.0f - dragPercent) * (float)this.mParent.getTotalDragDistance() + townTopOffset - (float)this.mTownHeight * (townScale - 1.0f) / 2.0f + townMoveOffset;
        matrix.postScale(townScale, townScale);
        matrix.postTranslate(offsetX, offsetY);
        canvas.drawBitmap(this.mTown, matrix, null);
    }

    private void drawSun(Canvas canvas) {
        Matrix matrix = this.mMatrix;
        matrix.reset();
        float dragPercent = this.mPercent;
        if (dragPercent > 1.0f) {
            dragPercent = (dragPercent + 9.0f) / 10.0f;
        }
        float sunRadius = (float)this.mSunSize / 2.0f;
        float sunRotateGrowth = 1.2f;
        float offsetX = this.mSunLeftOffset;
        float offsetY = this.mSunTopOffset + (float)(this.mParent.getTotalDragDistance() / 2) * (1.0f - dragPercent) - (float)this.mTop;
        float scalePercentDelta = dragPercent - 0.5f;
        if (scalePercentDelta > 0.0f) {
            float scalePercent = scalePercentDelta / 0.5f;
            float sunScale = 1.0f - 0.25f * scalePercent;
            sunRotateGrowth += 0.29999995f * scalePercent;
            matrix.preTranslate(offsetX + (sunRadius - sunRadius * sunScale), offsetY * (2.0f - sunScale));
            matrix.preScale(sunScale, sunScale);
            offsetX += sunRadius;
            offsetY = offsetY * (2.0f - sunScale) + sunRadius * sunScale;
        } else {
            matrix.postTranslate(offsetX, offsetY);
            offsetX += sunRadius;
            offsetY += sunRadius;
        }
        matrix.postRotate((float)(this.isRefreshing ? -360 : 360) * this.mRotate * (this.isRefreshing ? 1.0f : sunRotateGrowth), offsetX, offsetY);
        canvas.drawBitmap(this.mSun, matrix, null);
    }

    public void setPercent(float percent) {
        this.mPercent = percent;
    }

    public void setRotate(float rotate) {
        this.mRotate = rotate;
        this.invalidateSelf();
    }

    public void resetOriginals() {
        this.setPercent(0.0f);
        this.setRotate(0.0f);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, this.mSkyHeight + top);
    }

    @Override
    public void setAlpha(int alpha) {
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    public boolean isRunning() {
        return false;
    }

    public void start() {
        this.mAnimation.reset();
        this.isRefreshing = true;
        this.mParent.startAnimation(this.mAnimation);
    }

    public void stop() {
        this.mParent.clearAnimation();
        this.isRefreshing = false;
        this.resetOriginals();
    }

    private void setupAnimations() {
        this.mAnimation = new Animation(){

            public void applyTransformation(float interpolatedTime, Transformation t) {
                SunRefreshView.this.setRotate(interpolatedTime);
            }
        };
        this.mAnimation.setRepeatCount(-1);
        this.mAnimation.setRepeatMode(1);
        this.mAnimation.setInterpolator(LINEAR_INTERPOLATOR);
        this.mAnimation.setDuration(1000L);
    }
}

