/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance.histquotes2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yahoofinance.Utils;
import yahoofinance.YahooFinance;
import yahoofinance.histquotes.HistoricalQuote;
import yahoofinance.histquotes.Interval;
import yahoofinance.histquotes2.CrumbManager;
import yahoofinance.histquotes2.IntervalMapper;
import yahoofinance.histquotes2.QueryInterval;
import yahoofinance.util.RedirectableRequest;

public class HistQuotes2Request {
    private static final Logger log = LoggerFactory.getLogger(HistQuotes2Request.class);
    private final String symbol;
    private final Calendar from;
    private final Calendar to;
    private final QueryInterval interval;
    public static final Calendar DEFAULT_FROM = Calendar.getInstance();
    public static final Calendar DEFAULT_TO;
    public static final QueryInterval DEFAULT_INTERVAL;

    public HistQuotes2Request(String symbol) {
        this(symbol, DEFAULT_INTERVAL);
    }

    public HistQuotes2Request(String symbol, QueryInterval interval) {
        this(symbol, DEFAULT_FROM, DEFAULT_TO, interval);
    }

    public HistQuotes2Request(String symbol, Calendar from, Calendar to) {
        this(symbol, from, to, DEFAULT_INTERVAL);
    }

    public HistQuotes2Request(String symbol, Calendar from, Calendar to, QueryInterval interval) {
        this.symbol = symbol;
        this.from = this.cleanHistCalendar(from);
        this.to = this.cleanHistCalendar(to);
        this.interval = interval;
    }

    public HistQuotes2Request(String symbol, Date from, Date to) {
        this(symbol, from, to, DEFAULT_INTERVAL);
    }

    public HistQuotes2Request(String symbol, Date from, Date to, QueryInterval interval) {
        this(symbol, interval);
        this.from.setTime(from);
        this.to.setTime(to);
        this.cleanHistCalendar(this.from);
        this.cleanHistCalendar(this.to);
    }

    public HistQuotes2Request(String symbol, Interval interval) {
        this(symbol, DEFAULT_FROM, DEFAULT_TO, interval);
    }

    public HistQuotes2Request(String symbol, Calendar from, Calendar to, Interval interval) {
        this(symbol, from, to, IntervalMapper.get(interval));
    }

    public HistQuotes2Request(String symbol, Date from, Date to, Interval interval) {
        this(symbol, from, to, IntervalMapper.get(interval));
    }

    private Calendar cleanHistCalendar(Calendar cal) {
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal;
    }

    public List<HistoricalQuote> getResult() throws IOException {
        ArrayList<HistoricalQuote> result = new ArrayList<HistoricalQuote>();
        if (this.from.after(this.to)) {
            log.warn("Unable to retrieve historical quotes. From-date should not be after to-date. From: " + this.from.getTime() + ", to: " + this.to.getTime());
            return result;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("period1", String.valueOf(this.from.getTimeInMillis() / 1000L));
        params.put("period2", String.valueOf(this.to.getTimeInMillis() / 1000L));
        params.put("interval", this.interval.getTag());
        params.put("crumb", CrumbManager.getCrumb());
        String url = YahooFinance.HISTQUOTES2_BASE_URL + URLEncoder.encode(this.symbol, "UTF-8") + "?" + Utils.getURLParameters(params);
        log.info("Sending request: " + url);
        URL request = new URL(url);
        RedirectableRequest redirectableRequest = new RedirectableRequest(request, 5);
        redirectableRequest.setConnectTimeout(YahooFinance.CONNECTION_TIMEOUT);
        redirectableRequest.setReadTimeout(YahooFinance.CONNECTION_TIMEOUT);
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("Cookie", CrumbManager.getCookie());
        URLConnection connection = redirectableRequest.openConnection(requestProperties);
        InputStreamReader is = new InputStreamReader(connection.getInputStream());
        BufferedReader br = new BufferedReader(is);
        br.readLine();
        String line = br.readLine();
        while (line != null) {
            log.info("Parsing CSV line: " + Utils.unescape(line));
            HistoricalQuote quote = this.parseCSVLine(line);
            result.add(quote);
            line = br.readLine();
        }
        return result;
    }

    private HistoricalQuote parseCSVLine(String line) {
        String[] data = line.split(",");
        return new HistoricalQuote(this.symbol, Utils.parseHistDate(data[0]), Utils.getBigDecimal(data[1]), Utils.getBigDecimal(data[3]), Utils.getBigDecimal(data[2]), Utils.getBigDecimal(data[4]), Utils.getBigDecimal(data[5]), Utils.getLong(data[6]));
    }

    static {
        DEFAULT_FROM.add(1, -1);
        DEFAULT_TO = Calendar.getInstance();
        DEFAULT_INTERVAL = QueryInterval.MONTHLY;
    }
}

