/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance.quotes.fx;

import java.math.BigDecimal;
import yahoofinance.quotes.fx.FxQuotesRequest;

public class FxQuote {
    private String symbol;
    private BigDecimal price;

    public FxQuote(String symbol) {
        this.symbol = symbol;
        this.price = BigDecimal.ZERO;
    }

    public FxQuote(String symbol, BigDecimal price) {
        this.symbol = symbol;
        this.price = price;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public BigDecimal getPrice() {
        if (this.price.equals(BigDecimal.ZERO)) {
            return this.getPrice(true);
        }
        return this.price;
    }

    public BigDecimal getPrice(boolean refresh) {
        if (refresh) {
            FxQuotesRequest request = new FxQuotesRequest(this.symbol);
            this.price = ((FxQuote)request.getSingleResult()).getPrice();
        }
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String toString() {
        return this.symbol + ": " + this.price;
    }
}

