/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance.quotes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import yahoofinance.Utils;
import yahoofinance.YahooFinance;
import yahoofinance.quotes.QuotesProperty;

public abstract class QuotesRequest<T> {
    protected final String query;
    protected List<QuotesProperty> properties;

    public QuotesRequest(String query, List<QuotesProperty> properties) {
        this.query = query;
        this.properties = properties;
    }

    public String getQuery() {
        return this.query;
    }

    public List<QuotesProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<QuotesProperty> properties) {
        this.properties = properties;
    }

    protected abstract T parseCSVLine(String var1);

    private String getFieldsString() {
        StringBuilder result = new StringBuilder();
        for (QuotesProperty property : this.properties) {
            result.append(property.getTag());
        }
        return result.toString();
    }

    public T getSingleResult() {
        List<T> results = this.getResult();
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public List<T> getResult() {
        ArrayList<T> result = new ArrayList<T>();
        try {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("s", this.query);
            params.put("f", this.getFieldsString());
            params.put("e", ".csv");
            String url = "http://finance.yahoo.com/d/quotes.csv?" + Utils.getURLParameters(params);
            YahooFinance.logger.log(Level.INFO, "Sending request: " + url);
            URL request = new URL(url);
            URLConnection connection = request.openConnection();
            InputStreamReader is = new InputStreamReader(connection.getInputStream());
            BufferedReader br = new BufferedReader(is);
            String line = br.readLine();
            while (line != null) {
                if (line.equals("Missing Symbols List.")) {
                    YahooFinance.logger.log(Level.SEVERE, "The requested symbol was not recognized by Yahoo Finance");
                } else {
                    YahooFinance.logger.log(Level.INFO, "Parsing CSV line: " + Utils.unescape(line));
                    T data = this.parseCSVLine(line);
                    result.add(data);
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            YahooFinance.logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return result;
    }
}

