/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import yahoofinance.YahooFinance;
import yahoofinance.histquotes.HistQuotesRequest;
import yahoofinance.histquotes.HistoricalQuote;
import yahoofinance.histquotes.Interval;
import yahoofinance.quotes.stock.StockDividend;
import yahoofinance.quotes.stock.StockQuote;
import yahoofinance.quotes.stock.StockQuotesData;
import yahoofinance.quotes.stock.StockQuotesRequest;
import yahoofinance.quotes.stock.StockStats;

public class Stock {
    private final String symbol;
    private String name;
    private String currency;
    private String stockExchange;
    private StockQuote quote;
    private StockStats stats;
    private StockDividend dividend;
    private List<HistoricalQuote> history;

    public Stock(String symbol) {
        this.symbol = symbol;
    }

    private void update() {
        StockQuotesRequest request = new StockQuotesRequest(this.symbol);
        StockQuotesData data = (StockQuotesData)request.getSingleResult();
        if (data != null) {
            this.setQuote(data.getQuote());
            this.setStats(data.getStats());
            this.setDividend(data.getDividend());
            YahooFinance.logger.log(Level.INFO, "Updated Stock with symbol: {0}", this.symbol);
        } else {
            YahooFinance.logger.log(Level.SEVERE, "Failed to update Stock with symbol: {0}", this.symbol);
        }
    }

    public StockQuote getQuote() {
        if (this.quote != null) {
            return this.quote;
        }
        return this.getQuote(true);
    }

    public StockQuote getQuote(boolean refresh) {
        if (refresh) {
            this.update();
        }
        return this.quote;
    }

    public void setQuote(StockQuote quote) {
        this.quote = quote;
    }

    public StockStats getStats() {
        if (this.stats != null) {
            return this.stats;
        }
        return this.getStats(true);
    }

    public StockStats getStats(boolean refresh) {
        if (refresh) {
            this.update();
        }
        return this.stats;
    }

    public void setStats(StockStats stats) {
        this.stats = stats;
    }

    public StockDividend getDividend() {
        if (this.dividend != null) {
            return this.dividend;
        }
        return this.getDividend(true);
    }

    public StockDividend getDividend(boolean refresh) {
        if (refresh) {
            this.update();
        }
        return this.dividend;
    }

    public void setDividend(StockDividend dividend) {
        this.dividend = dividend;
    }

    public List<HistoricalQuote> getHistory() {
        if (this.history != null) {
            return this.history;
        }
        return this.getHistory(HistQuotesRequest.DEFAULT_FROM);
    }

    public List<HistoricalQuote> getHistory(Interval interval) {
        return this.getHistory(HistQuotesRequest.DEFAULT_FROM, interval);
    }

    public List<HistoricalQuote> getHistory(Calendar from) {
        return this.getHistory(from, HistQuotesRequest.DEFAULT_TO);
    }

    public List<HistoricalQuote> getHistory(Calendar from, Interval interval) {
        return this.getHistory(from, HistQuotesRequest.DEFAULT_TO, interval);
    }

    public List<HistoricalQuote> getHistory(Calendar from, Calendar to) {
        return this.getHistory(from, to, Interval.MONTHLY);
    }

    public List<HistoricalQuote> getHistory(Calendar from, Calendar to, Interval interval) {
        HistQuotesRequest hist = new HistQuotesRequest(this.symbol, from, to, interval);
        this.setHistory(hist.getResult());
        return this.history;
    }

    public void setHistory(List<HistoricalQuote> history) {
        this.history = history;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStockExchange() {
        return this.stockExchange;
    }

    public void setStockExchange(String stockExchange) {
        this.stockExchange = stockExchange;
    }

    public String toString() {
        return this.symbol + ": " + this.quote.getPrice();
    }

    public void print() {
        System.out.println(this.symbol);
        System.out.println("--------------------------------");
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                System.out.println(f.getName() + ": " + f.get(this));
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Stock.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Stock.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println("--------------------------------");
    }
}

