/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance.histquotes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import yahoofinance.Utils;
import yahoofinance.YahooFinance;
import yahoofinance.histquotes.HistoricalQuote;
import yahoofinance.histquotes.Interval;

public class HistQuotesRequest {
    private final String symbol;
    private final Calendar from;
    private final Calendar to;
    private final Interval interval;
    public static final Calendar DEFAULT_FROM = Calendar.getInstance();
    public static final Calendar DEFAULT_TO;
    public static final Interval DEFAULT_INTERVAL;

    public HistQuotesRequest(String symbol) {
        this(symbol, DEFAULT_INTERVAL);
    }

    public HistQuotesRequest(String symbol, Interval interval) {
        this.symbol = symbol;
        this.interval = interval;
        this.from = DEFAULT_FROM;
        this.to = DEFAULT_TO;
    }

    public HistQuotesRequest(String symbol, Calendar from, Calendar to) {
        this(symbol, from, to, DEFAULT_INTERVAL);
    }

    public HistQuotesRequest(String symbol, Calendar from, Calendar to, Interval interval) {
        this.symbol = symbol;
        this.from = from;
        this.to = to;
        this.interval = interval;
    }

    public HistQuotesRequest(String symbol, Date from, Date to) {
        this(symbol, from, to, DEFAULT_INTERVAL);
    }

    public HistQuotesRequest(String symbol, Date from, Date to, Interval interval) {
        this(symbol, interval);
        this.from.setTime(from);
        this.to.setTime(to);
    }

    public List<HistoricalQuote> getResult() {
        ArrayList<HistoricalQuote> result = new ArrayList<HistoricalQuote>();
        try {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("s", this.symbol);
            params.put("a", String.valueOf(this.from.get(2)));
            params.put("b", String.valueOf(this.from.get(5)));
            params.put("c", String.valueOf(this.from.get(1)));
            params.put("d", String.valueOf(this.to.get(2)));
            params.put("e", String.valueOf(this.to.get(5)));
            params.put("f", String.valueOf(this.to.get(1)));
            params.put("g", this.interval.getTag());
            params.put("ignore", ".csv");
            String url = "http://ichart.yahoo.com/table.csv?" + Utils.getURLParameters(params);
            YahooFinance.logger.log(Level.INFO, "Sending request: " + url);
            URL request = new URL(url);
            URLConnection connection = request.openConnection();
            InputStreamReader is = new InputStreamReader(connection.getInputStream());
            BufferedReader br = new BufferedReader(is);
            br.readLine();
            String line = br.readLine();
            while (line != null) {
                YahooFinance.logger.log(Level.INFO, "Parsing CSV line: " + Utils.unescape(line));
                HistoricalQuote quote = this.parseCSVLine(line);
                result.add(quote);
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            YahooFinance.logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return result;
    }

    private HistoricalQuote parseCSVLine(String line) {
        String[] data = line.split(",");
        return new HistoricalQuote(this.symbol, Utils.parseHistDate(data[0]), Utils.getBigDecimal(data[1]), Utils.getBigDecimal(data[3]), Utils.getBigDecimal(data[2]), Utils.getBigDecimal(data[4]), Utils.getBigDecimal(data[6]), Utils.getLong(data[5]));
    }

    static {
        DEFAULT_FROM.add(1, -1);
        DEFAULT_TO = Calendar.getInstance();
        DEFAULT_INTERVAL = Interval.MONTHLY;
    }
}

