/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import yahoofinance.Stock;
import yahoofinance.Utils;
import yahoofinance.histquotes.HistQuotesRequest;
import yahoofinance.histquotes.Interval;
import yahoofinance.quotes.fx.FxQuote;
import yahoofinance.quotes.fx.FxQuotesRequest;
import yahoofinance.quotes.stock.StockQuotesData;
import yahoofinance.quotes.stock.StockQuotesRequest;

public class YahooFinance {
    public static final String QUOTES_BASE_URL = "http://finance.yahoo.com/d/quotes.csv";
    public static final String HISTQUOTES_BASE_URL = "http://ichart.yahoo.com/table.csv";
    public static final String QUOTES_CSV_DELIMITER = ",";
    public static final String TIMEZONE = "America/New_York";
    public static final Logger logger = Logger.getLogger(YahooFinance.class.getName());

    public static Stock get(String symbol) {
        return YahooFinance.get(symbol, false);
    }

    public static Stock get(String symbol, boolean includeHistorical) {
        Map<String, Stock> result = YahooFinance.getQuotes(symbol, includeHistorical);
        return result.get(symbol);
    }

    public static Stock get(String symbol, Interval interval) {
        return YahooFinance.get(symbol, HistQuotesRequest.DEFAULT_FROM, HistQuotesRequest.DEFAULT_TO, interval);
    }

    public static Stock get(String symbol, Calendar from) {
        return YahooFinance.get(symbol, from, HistQuotesRequest.DEFAULT_TO, HistQuotesRequest.DEFAULT_INTERVAL);
    }

    public static Stock get(String symbol, Calendar from, Interval interval) {
        return YahooFinance.get(symbol, from, HistQuotesRequest.DEFAULT_TO, interval);
    }

    public static Stock get(String symbol, Calendar from, Calendar to) {
        return YahooFinance.get(symbol, from, to, HistQuotesRequest.DEFAULT_INTERVAL);
    }

    public static Stock get(String symbol, Calendar from, Calendar to, Interval interval) {
        Map<String, Stock> result = YahooFinance.getQuotes(symbol, from, to, interval);
        return result.get(symbol);
    }

    public static Map<String, Stock> get(String[] symbols) {
        return YahooFinance.get(symbols, false);
    }

    public static Map<String, Stock> get(String[] symbols, boolean includeHistorical) {
        return YahooFinance.getQuotes(Utils.join(symbols, QUOTES_CSV_DELIMITER), includeHistorical);
    }

    public static Map<String, Stock> get(String[] symbols, Interval interval) {
        return YahooFinance.getQuotes(Utils.join(symbols, QUOTES_CSV_DELIMITER), HistQuotesRequest.DEFAULT_FROM, HistQuotesRequest.DEFAULT_TO, interval);
    }

    public static Map<String, Stock> get(String[] symbols, Calendar from) {
        return YahooFinance.getQuotes(Utils.join(symbols, QUOTES_CSV_DELIMITER), from, HistQuotesRequest.DEFAULT_TO, HistQuotesRequest.DEFAULT_INTERVAL);
    }

    public static Map<String, Stock> get(String[] symbols, Calendar from, Interval interval) {
        return YahooFinance.getQuotes(Utils.join(symbols, QUOTES_CSV_DELIMITER), from, HistQuotesRequest.DEFAULT_TO, interval);
    }

    public static Map<String, Stock> get(String[] symbols, Calendar from, Calendar to) {
        return YahooFinance.getQuotes(Utils.join(symbols, QUOTES_CSV_DELIMITER), from, to, HistQuotesRequest.DEFAULT_INTERVAL);
    }

    public static Map<String, Stock> get(String[] symbols, Calendar from, Calendar to, Interval interval) {
        return YahooFinance.getQuotes(Utils.join(symbols, QUOTES_CSV_DELIMITER), from, to, interval);
    }

    public static FxQuote getFx(String symbol) {
        FxQuotesRequest request = new FxQuotesRequest(symbol);
        return (FxQuote)request.getSingleResult();
    }

    public static Map<String, FxQuote> getFx(String[] symbols) {
        FxQuotesRequest request = new FxQuotesRequest(Utils.join(symbols, QUOTES_CSV_DELIMITER));
        List quotes = request.getResult();
        HashMap<String, FxQuote> result = new HashMap<String, FxQuote>();
        for (FxQuote quote : quotes) {
            result.put(quote.getSymbol(), quote);
        }
        return result;
    }

    private static Map<String, Stock> getQuotes(String query, boolean includeHistorical) {
        StockQuotesRequest request = new StockQuotesRequest(query);
        List quotes = request.getResult();
        HashMap<String, Stock> result = new HashMap<String, Stock>();
        for (StockQuotesData data : quotes) {
            Stock s = data.getStock();
            result.put(s.getSymbol(), s);
        }
        if (includeHistorical) {
            for (Stock s : result.values()) {
                s.getHistory();
            }
        }
        return result;
    }

    private static Map<String, Stock> getQuotes(String query, Calendar from, Calendar to, Interval interval) {
        Map<String, Stock> stocks = YahooFinance.getQuotes(query, false);
        stocks = YahooFinance.fetchHistoricalQuotes(stocks, from, to, interval);
        return stocks;
    }

    private static Map<String, Stock> fetchHistoricalQuotes(Map<String, Stock> stocks, Calendar from, Calendar to, Interval interval) {
        for (Stock s : stocks.values()) {
            s.getHistory(from, to, interval);
        }
        return stocks;
    }
}

