/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.KeyId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.SharedKeyGenerator;
import com.yahoo.vespa.security.tool.CliUtils;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import com.yahoo.vespa.security.tool.crypto.CipherUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.interfaces.XECPrivateKey;
import java.util.List;
import java.util.Optional;
import javax.crypto.Cipher;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class DecryptTool
implements Tool {
    static final String OUTPUT_FILE_OPTION = "output-file";
    static final String RECIPIENT_PRIVATE_KEY_FILE_OPTION = "recipient-private-key-file";
    static final String KEY_ID_OPTION = "key-id";
    static final String TOKEN_OPTION = "token";
    private static final List<Option> OPTIONS = List.of(Option.builder((String)"o").longOpt("output-file").hasArg(true).required(false).desc("Output file for decrypted plaintext. Specify '-' (without the quotes) to write plaintext to STDOUT instead of a file.").build(), Option.builder((String)"k").longOpt("recipient-private-key-file").hasArg(true).required(false).desc("Recipient private key file").build(), Option.builder((String)"i").longOpt("key-id").hasArg(true).required(false).desc("Numeric ID of recipient key. If this is not provided, the key ID stored as part of the token is not verified.").build(), Option.builder((String)"t").longOpt("token").hasArg(true).required(false).desc("Token generated when the input file was encrypted").build());

    @Override
    public String name() {
        return "decrypt";
    }

    @Override
    public ToolDescription description() {
        return new ToolDescription("<encrypted file> <options>", "Decrypts a file using a provided token and a secret private key. The file must previously have been encrypted using the public key component of the given private key.\n\nTo decrypt the contents of STDIN, specify an input file of '-' (without the quotes).", "Note: this is a BETA tool version; its interface may be changed at any time", OPTIONS);
    }

    @Override
    public int invoke(ToolInvocation invocation) {
        try {
            KeyId myKeyId;
            CommandLine arguments = invocation.arguments();
            String[] leftoverArgs = arguments.getArgs();
            if (leftoverArgs.length != 1) {
                throw new IllegalArgumentException("Expected exactly 1 file argument to decrypt");
            }
            String inputArg = leftoverArgs[0];
            Optional<Object> maybeKeyId = Optional.ofNullable(arguments.hasOption(KEY_ID_OPTION) ? arguments.getOptionValue(KEY_ID_OPTION) : null);
            String outputArg = CliUtils.optionOrThrow(arguments, OUTPUT_FILE_OPTION);
            Path privKeyPath = Paths.get(CliUtils.optionOrThrow(arguments, RECIPIENT_PRIVATE_KEY_FILE_OPTION), new String[0]);
            String tokenString = CliUtils.optionOrThrow(arguments, TOKEN_OPTION);
            SealedSharedKey sealedSharedKey = SealedSharedKey.fromTokenString((String)tokenString.strip());
            if (maybeKeyId.isPresent() && !(myKeyId = KeyId.ofString((String)maybeKeyId.get())).equals((Object)sealedSharedKey.keyId())) {
                throw new IllegalArgumentException("Key ID specified with --key-id does not match key ID used when generating the supplied token");
            }
            XECPrivateKey privateKey = KeyUtils.fromBase64EncodedX25519PrivateKey((String)Files.readString(privKeyPath).strip());
            SecretSharedKey secretShared = SharedKeyGenerator.fromSealedKey((SealedSharedKey)sealedSharedKey, (PrivateKey)privateKey);
            Cipher cipher = SharedKeyGenerator.makeAesGcmDecryptionCipher((SecretSharedKey)secretShared);
            try (InputStream inStream = CliUtils.inputStreamFromFileOrStream(inputArg, invocation.stdIn());
                 OutputStream outStream = CliUtils.outputStreamToFileOrStream(outputArg, invocation.stdOut());){
                CipherUtils.streamEncipher(inStream, outStream, cipher);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }
}

