/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.merge;

import java.util.ArrayList;
import java.util.List;

public record MergeClientParameters(String outputFile, List<String> inputFiles, long minKeep, boolean zstCompress) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String outputFile;
        private final List<String> inputFiles = new ArrayList<String>();
        private long minKeep = Long.MIN_VALUE;
        private boolean zstCompress = false;

        public Builder outputFile(String value) {
            this.outputFile = value;
            return this;
        }

        public Builder addInputFile(String file) {
            this.inputFiles.add(file);
            return this;
        }

        public Builder addInputFiles(List<String> files) {
            files.forEach(this::addInputFile);
            return this;
        }

        public Builder minKeep(long minKeep) {
            this.minKeep = minKeep;
            return this;
        }

        public Builder zstCompress(boolean value) {
            this.zstCompress = value;
            return this;
        }

        public MergeClientParameters build() {
            return new MergeClientParameters(this.outputFile, this.inputFiles, this.minKeep, this.zstCompress);
        }
    }
}

