/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public final class VespaSignificanceTsvReader
implements AutoCloseable {
    public static final String MAGIC = "#VESPA_SIGNIFICANCE_TSV";
    public static final String VERSION = "v1";
    public static final String HEADER_END = "--END-HEADER--";
    public static final String DOCUMENT_COUNT_HEADER = "document_count";
    public static final String SORTED_HEADER = "sorted";
    public static final String CREATED_AT_HEADER = "created_at";
    private final BufferedReader bufferedReader;
    private final Header header;
    private String currentTerm;
    private long currentDf;
    private boolean eof;
    private final boolean enforceSorted;
    private String lastTerm;

    public VespaSignificanceTsvReader(Path path) throws IOException {
        this.bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
        this.header = VespaSignificanceTsvReader.readAndValidateHeader(this.bufferedReader);
        this.enforceSorted = this.header.sorted;
    }

    public VespaSignificanceTsvReader(Reader reader) throws IOException {
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 65536);
        this.header = VespaSignificanceTsvReader.readAndValidateHeader(this.bufferedReader);
        this.enforceSorted = this.header.sorted;
    }

    public Header header() {
        return this.header;
    }

    public boolean next() throws IOException {
        String line;
        if (this.eof) {
            return false;
        }
        while ((line = this.bufferedReader.readLine()) != null) {
            long df;
            if (line.isBlank()) continue;
            int tab = line.indexOf(9);
            if (tab <= 0) {
                throw new IllegalArgumentException("Bad data line (missing tab): " + VespaSignificanceTsvReader.truncate(line));
            }
            String term = line.substring(0, tab);
            String dfStr = line.substring(tab + 1);
            if (term.indexOf(9) >= 0) {
                throw new IllegalArgumentException("Term contains tab: " + VespaSignificanceTsvReader.truncate(term));
            }
            try {
                df = Long.parseLong(dfStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad DF (not a number): " + VespaSignificanceTsvReader.truncate(dfStr));
            }
            if (this.enforceSorted && this.lastTerm != null && term.compareTo(this.lastTerm) <= 0) {
                throw new IllegalArgumentException("Not strictly ascending: '" + term + "' <= '" + this.lastTerm + "'");
            }
            this.lastTerm = term;
            this.currentTerm = term;
            this.currentDf = df;
            return true;
        }
        this.eof = true;
        return false;
    }

    public String term() {
        return this.currentTerm;
    }

    public long df() {
        return this.currentDf;
    }

    @Override
    public void close() throws IOException {
        this.bufferedReader.close();
    }

    private static Header readAndValidateHeader(BufferedReader bufferedReader) throws IOException {
        Instant createdAt;
        boolean sorted;
        long docCount;
        String createdStr;
        String sortedStr;
        String line;
        String line1 = bufferedReader.readLine();
        if (line1 == null) {
            throw new IllegalArgumentException("Empty file");
        }
        String expected = "#VESPA_SIGNIFICANCE_TSV\tv1";
        if (!Objects.equals(line1, expected)) {
            throw new IllegalArgumentException("Bad magic/version. Expected '" + expected + "', got: " + VespaSignificanceTsvReader.truncate(line1));
        }
        LinkedHashMap<String, String> kv = new LinkedHashMap<String, String>();
        while ((line = bufferedReader.readLine()) != null && !Objects.equals(line, HEADER_END)) {
            if (line.isBlank()) continue;
            int tab = line.indexOf(9);
            if (tab <= 0) {
                throw new IllegalArgumentException("Malformed header line (expected key<TAB>value): " + VespaSignificanceTsvReader.truncate(line));
            }
            String key = line.substring(0, tab).trim();
            String val = line.substring(tab + 1).trim();
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Empty header key");
            }
            kv.put(key, val);
        }
        if (line == null) {
            throw new IllegalArgumentException("Missing header terminator: --END-HEADER--");
        }
        ArrayList<String> missingKeys = new ArrayList<String>();
        String documentCountString = (String)kv.get(DOCUMENT_COUNT_HEADER);
        if (documentCountString == null) {
            missingKeys.add(DOCUMENT_COUNT_HEADER);
        }
        if ((sortedStr = (String)kv.get(SORTED_HEADER)) == null) {
            missingKeys.add(SORTED_HEADER);
        }
        if ((createdStr = (String)kv.get(CREATED_AT_HEADER)) == null) {
            missingKeys.add(CREATED_AT_HEADER);
        }
        if (!missingKeys.isEmpty()) {
            throw new IllegalArgumentException("Header missing required keys: " + String.join((CharSequence)", ", missingKeys));
        }
        try {
            docCount = Long.parseLong(documentCountString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("document_count must be integer");
        }
        if (docCount < 0L) {
            throw new IllegalArgumentException("document_count must be >= 0");
        }
        if ("true".equalsIgnoreCase(sortedStr)) {
            sorted = true;
        } else if ("false".equalsIgnoreCase(sortedStr)) {
            sorted = false;
        } else {
            throw new IllegalArgumentException("sorted must be 'true' or 'false'");
        }
        try {
            createdAt = Instant.parse(createdStr);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("created_at must be ISO-8601 instant, e.g. 2025-10-13T11:59:00Z");
        }
        return new Header(docCount, sorted, createdAt, Collections.unmodifiableMap(kv));
    }

    private static String truncate(String s) {
        if (s == null) {
            return "null";
        }
        return (s = s.replace("\n", "\\n")).length() > 120 ? s.substring(0, 120) + "\u2026" : s;
    }

    public static Loaded parseAll(Path path) throws IOException {
        try (VespaSignificanceTsvReader reader = new VespaSignificanceTsvReader(path);){
            TreeMap<String, Long> df = new TreeMap<String, Long>();
            while (reader.next()) {
                df.merge(reader.term(), reader.df(), Long::sum);
            }
            Loaded loaded = new Loaded(reader.header(), Collections.unmodifiableSortedMap(df));
            return loaded;
        }
    }

    public record Header(long documentCount, boolean sorted, Instant createdAt, Map<String, String> raw) {
    }

    public record Loaded(Header header, SortedMap<String, Long> df) {
    }
}

