/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.export;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public record VespaIndexInspectClient(String executable, ProcessStarter processStarter) {
    public VespaIndexInspectClient() {
        this("vespa-index-inspect");
    }

    VespaIndexInspectClient(String executable) {
        this(executable, cmd -> new ProcessBuilder(cmd).redirectErrorStream(true).start());
    }

    public VespaIndexInspectClient {
        Objects.requireNonNull(executable, "executable is null");
        if (executable.isBlank()) {
            throw new IllegalArgumentException("executable is blank");
        }
        Objects.requireNonNull(processStarter, "processStarter is null");
    }

    static TermDocumentFrequency parseDumpWordsLine(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        int tab = line.indexOf(9);
        if (tab <= 0 || tab == line.length() - 1) {
            return null;
        }
        String term = line.substring(0, tab);
        String numStr = line.substring(tab + 1).trim();
        try {
            long n = Long.parseLong(numStr);
            return new TermDocumentFrequency(term, n);
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    public Stream<TermDocumentFrequency> streamDumpWords(Path indexDir, String field) throws IOException {
        Objects.requireNonNull(indexDir, "indexDir is null");
        Objects.requireNonNull(field, "field is null");
        if (field.isBlank()) {
            throw new IllegalArgumentException("field is blank");
        }
        List<String> cmd = List.of(this.executable, "dumpwords", "--indexdir", indexDir.toString(), "--field", field);
        Process p = this.processStarter.start(cmd);
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
        DumpWordsProcessIterator it = new DumpWordsProcessIterator(p, br);
        Stream<TermDocumentFrequency> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 272), false);
        return (Stream)stream.onClose(() -> {
            try {
                it.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    static Stream<TermDocumentFrequency> streamDumpWords(Reader reader) {
        BufferedReader b;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (b = (BufferedReader)reader) : new BufferedReader(reader);
        DumpWordsLineIterator it = new DumpWordsLineIterator(bufferedReader);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 272), false).onClose(() -> {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @FunctionalInterface
    public static interface ProcessStarter {
        public Process start(List<String> var1) throws IOException;
    }

    public record TermDocumentFrequency(String term, long documentFrequency) {
        @Override
        public String toString() {
            return this.term + "\t" + this.documentFrequency;
        }
    }

    private static final class DumpWordsProcessIterator
    implements Iterator<TermDocumentFrequency>,
    AutoCloseable {
        private final Process process;
        private boolean closed;
        private final BufferedReader br;
        private final Iterator<TermDocumentFrequency> delegate;

        DumpWordsProcessIterator(Process process, BufferedReader br) {
            this.process = process;
            this.br = br;
            this.delegate = new DumpWordsLineIterator(br);
        }

        @Override
        public boolean hasNext() {
            return !this.closed && this.delegate.hasNext();
        }

        @Override
        public TermDocumentFrequency next() {
            if (this.closed) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            IOException first = null;
            try {
                this.br.close();
            }
            catch (IOException e) {
                first = e;
            }
            try {
                int exit;
                if (!this.process.waitFor(5L, TimeUnit.SECONDS)) {
                    this.process.destroyForcibly();
                    this.process.waitFor(3L, TimeUnit.SECONDS);
                }
                if ((exit = this.process.exitValue()) != 0) {
                    IOException ioe = new IOException("vespa-index-inspect exited with code " + exit);
                    if (first != null) {
                        ioe.addSuppressed(first);
                    }
                    throw ioe;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (first != null) {
                    throw first;
                }
                throw new IOException("Interrupted waiting for process exit", ie);
            }
            if (first != null) {
                throw first;
            }
        }
    }

    private static final class DumpWordsLineIterator
    implements Iterator<TermDocumentFrequency> {
        private final BufferedReader br;
        private TermDocumentFrequency nextRow;
        private boolean eof;

        DumpWordsLineIterator(BufferedReader br) {
            this.br = br;
        }

        @Override
        public boolean hasNext() {
            if (this.nextRow != null) {
                return true;
            }
            if (this.eof) {
                return false;
            }
            try {
                String line;
                while ((line = this.br.readLine()) != null) {
                    TermDocumentFrequency parsed = VespaIndexInspectClient.parseDumpWordsLine(line);
                    if (parsed == null) continue;
                    this.nextRow = parsed;
                    return true;
                }
                this.eof = true;
                return false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public TermDocumentFrequency next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TermDocumentFrequency out = this.nextRow;
            this.nextRow = null;
            return out;
        }
    }
}

