/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasignificance;

public class ClientParameters {
    public final boolean help;
    public final String inputFile;
    public final String format;
    public final String outputFile;
    public final String field;
    public final String language;
    public final boolean zstCompression;

    public ClientParameters(boolean help, String inputFile, String format, String outputFile, String field, String language, boolean zstCompression) {
        this.help = help;
        this.inputFile = inputFile;
        this.format = format;
        this.outputFile = outputFile;
        this.field = field;
        this.language = language;
        this.zstCompression = zstCompression;
    }

    public static class Builder {
        private boolean help;
        private String inputFile;
        private String format;
        private String outputFile;
        private String field;
        private String language;
        private boolean zstCompression;

        public Builder setHelp(boolean help) {
            this.help = help;
            return this;
        }

        public Builder setInputFile(String inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setOutputFile(String outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder setZstCompression(String useZstCompression) {
            this.zstCompression = Boolean.parseBoolean(useZstCompression);
            return this;
        }

        public ClientParameters build() {
            return new ClientParameters(this.help, this.inputFile, this.format, this.outputFile, this.field, this.language, this.zstCompression);
        }
    }
}

