/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.ArrayUtils;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class TokenInfoTool
implements Tool {
    private static final List<Option> OPTIONS = List.of();

    @Override
    public String name() {
        return "token-info";
    }

    @Override
    public ToolDescription description() {
        return new ToolDescription("<token string>", "Dumps information about the various components of a token", "Note: this is a BETA tool version; its interface may be changed at any time", OPTIONS);
    }

    @Override
    public int invoke(ToolInvocation invocation) {
        CommandLine arguments = invocation.arguments();
        String[] leftoverArgs = arguments.getArgs();
        if (leftoverArgs.length != 1) {
            throw new IllegalArgumentException("Expected exactly 1 token string argument");
        }
        SealedSharedKey token = SealedSharedKey.fromTokenString((String)leftoverArgs[0]);
        PrintStream stdOut = invocation.stdOut();
        stdOut.format("Version:         %d\n", token.tokenVersion());
        stdOut.format("Key ID:          %s (%s)\n", StringUtilities.escape((String)token.keyId().asString()), ArrayUtils.hex((byte[])token.keyId().asBytes()));
        stdOut.format("HPKE enc:        %s\n", ArrayUtils.hex((byte[])token.enc()));
        stdOut.format("HPKE ciphertext: %s\n", ArrayUtils.hex((byte[])token.ciphertext()));
        return 0;
    }
}

