/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.feed.perf;

import com.yahoo.messagebus.routing.Route;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

class FeederParams {
    private static final int BUFFER_SIZE = 0x100000;
    private PrintStream stdErr = System.err;
    private PrintStream stdOut = System.out;
    private Route route = Route.parse((String)"default");
    private String configId = "client";
    private OutputStream dumpStream = null;
    private DumpFormat dumpFormat = DumpFormat.JSON;
    private boolean benchmarkMode = false;
    private int numDispatchThreads = 1;
    private int maxPending = 0;
    private double timeout = 180.0;
    private double windowSizeBackOff = 0.95;
    private double windowDecrementFactor = 1.2;
    private double windowResizeRate = 3.0;
    private int windowIncrementSize = 20;
    private int numConnectionsPerTarget = 1;
    private long numMessagesToSend = Long.MAX_VALUE;
    private List<InputStream> inputStreams = new ArrayList<InputStream>();

    FeederParams() {
        this.inputStreams.add(System.in);
    }

    PrintStream getStdErr() {
        return this.stdErr;
    }

    FeederParams setStdErr(PrintStream stdErr) {
        this.stdErr = stdErr;
        return this;
    }

    PrintStream getStdOut() {
        return this.stdOut;
    }

    FeederParams setStdOut(PrintStream stdOut) {
        this.stdOut = stdOut;
        return this;
    }

    Route getRoute() {
        return this.route;
    }

    OutputStream getDumpStream() {
        return this.dumpStream;
    }

    FeederParams setDumpStream(OutputStream dumpStream) {
        this.dumpStream = dumpStream;
        return this;
    }

    DumpFormat getDumpFormat() {
        return this.dumpFormat;
    }

    FeederParams setDumpFormat(DumpFormat dumpFormat) {
        this.dumpFormat = dumpFormat;
        return this;
    }

    String getConfigId() {
        return this.configId;
    }

    FeederParams setConfigId(String configId) {
        this.configId = configId;
        return this;
    }

    public double getWindowSizeBackOff() {
        return this.windowSizeBackOff;
    }

    public double getWindowDecrementFactor() {
        return this.windowDecrementFactor;
    }

    public double getWindowResizeRate() {
        return this.windowResizeRate;
    }

    public double getTimeout() {
        return this.timeout;
    }

    public int getWindowIncrementSize() {
        return this.windowIncrementSize;
    }

    int getNumConnectionsPerTarget() {
        return this.numConnectionsPerTarget;
    }

    long getNumMessagesToSend() {
        return this.numMessagesToSend;
    }

    boolean isSerialTransferEnabled() {
        return this.maxPending == 1;
    }

    FeederParams setSerialTransfer() {
        this.maxPending = 1;
        this.numDispatchThreads = 1;
        return this;
    }

    List<InputStream> getInputStreams() {
        return this.inputStreams;
    }

    FeederParams setInputStreams(List<InputStream> inputStreams) {
        this.inputStreams = inputStreams;
        return this;
    }

    int getNumDispatchThreads() {
        return this.numDispatchThreads;
    }

    int getMaxPending() {
        return this.maxPending;
    }

    boolean isBenchmarkMode() {
        return this.benchmarkMode;
    }

    FeederParams parseArgs(String ... args) throws ParseException, FileNotFoundException {
        Options opts = new Options();
        opts.addOption("s", "serial", false, "use serial transfer mode, at most 1 pending operation and a single thread");
        opts.addOption("n", "numthreads", true, "Number of clients for sending messages. Anything, but 1 will bypass sequencing by document id.");
        opts.addOption("m", "maxpending", true, "Max number of inflights messages. Default is auto.");
        opts.addOption("r", "route", true, "Route for sending messages. default is 'default'....");
        opts.addOption("b", "mode", true, "Mode for benchmarking.");
        opts.addOption("o", "output", true, "File to write to. Extensions gives format (.xml, .json, .vespa) json will be produced if no extension.");
        opts.addOption("c", "numconnections", true, "Number of connections per host.");
        opts.addOption("t", "timeout", true, "Timeout for a message in seconds. default = " + this.timeout);
        opts.addOption("l", "nummessages", true, "Number of messages to send (all is default).");
        opts.addOption("wi", "window_incrementsize", true, "Dynamic window increment step size. default = " + this.windowIncrementSize);
        opts.addOption("wd", "window_decrementfactor", true, "Dynamic window decrement step size factor. default = " + this.windowDecrementFactor);
        opts.addOption("wb", "window_backoffactor", true, "Dynamic window backoff factor. default = " + this.windowSizeBackOff);
        opts.addOption("wr", "window_resizerate", true, "Dynamic window resize rate. default = " + this.windowResizeRate);
        CommandLine cmd = new DefaultParser().parse(opts, args);
        if (cmd.hasOption('n')) {
            this.numDispatchThreads = Integer.valueOf(cmd.getOptionValue('n').trim());
        }
        if (cmd.hasOption('m')) {
            this.maxPending = Integer.valueOf(cmd.getOptionValue('m').trim());
        }
        if (cmd.hasOption('c')) {
            this.numConnectionsPerTarget = Integer.valueOf(cmd.getOptionValue('c').trim());
        }
        if (cmd.hasOption("wi")) {
            this.windowIncrementSize = Integer.valueOf(cmd.getOptionValue("wi").trim());
        }
        if (cmd.hasOption("wd")) {
            this.windowDecrementFactor = Double.valueOf(cmd.getOptionValue("wd").trim());
        }
        if (cmd.hasOption("wb")) {
            this.windowSizeBackOff = Double.valueOf(cmd.getOptionValue("wb").trim());
        }
        if (cmd.hasOption("wr")) {
            this.windowResizeRate = Double.valueOf(cmd.getOptionValue("wr").trim());
        }
        if (cmd.hasOption('r')) {
            this.route = Route.parse((String)cmd.getOptionValue('r').trim());
        }
        if (cmd.hasOption("t")) {
            this.timeout = Double.valueOf(cmd.getOptionValue("t").trim());
        }
        this.benchmarkMode = cmd.hasOption('b');
        if (cmd.hasOption('o')) {
            String fileName = cmd.getOptionValue('o').trim();
            this.dumpStream = new FileOutputStream(new File(fileName));
            if (fileName.endsWith(".vespa")) {
                this.dumpFormat = DumpFormat.VESPA;
            }
        }
        if (cmd.hasOption('s')) {
            this.setSerialTransfer();
        }
        if (cmd.hasOption('l')) {
            this.numMessagesToSend = Long.valueOf(cmd.getOptionValue('l').trim());
        }
        if (!cmd.getArgList().isEmpty()) {
            this.inputStreams.clear();
            for (String fileName : cmd.getArgList()) {
                this.inputStreams.add(new BufferedInputStream(new FileInputStream(new File(fileName)), 0x100000));
            }
        }
        return this;
    }

    static enum DumpFormat {
        JSON,
        VESPA;

    }
}

