/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespafeeder;

import com.yahoo.clientmetrics.MessageTypeMetricSet;
import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.concurrent.Timer;
import com.yahoo.metrics.Metric;
import com.yahoo.metrics.MetricSet;
import com.yahoo.metrics.MetricVisitor;
import com.yahoo.metrics.SumMetric;
import java.io.IOException;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public class ProgressPrinter
implements RouteMetricSet.ProgressCallback {
    private long startTime = 0L;
    private long lastProgressTime = 0L;
    private long lastVerboseProgress = 0L;
    final Timer timer;
    final PrintStream output;

    public ProgressPrinter(Timer timer, PrintStream output) {
        this.timer = timer;
        this.output = output;
        this.lastProgressTime = this.startTime = timer.milliTime();
        this.lastVerboseProgress = this.startTime;
    }

    public static String getDashes(int count) {
        Object dashes = "";
        for (int i = 0; i < count; ++i) {
            dashes = (String)dashes + "-";
        }
        return dashes;
    }

    public synchronized void renderStatusText(RouteMetricSet metrics, PrintStream stream) throws IOException {
        String headline = "Messages sent to vespa (route " + metrics.getName() + ") :";
        stream.println(headline);
        stream.println(ProgressPrinter.getDashes(headline.length()));
        metrics.visit((MetricVisitor)new PrintVisitor(stream), false);
    }

    public long getOkMessageCount(RouteMetricSet metrics) {
        Metric latency;
        SumMetric sum = (SumMetric)metrics.getMetric("total");
        MetricSet ms = (MetricSet)sum.generateSum();
        if (ms != null && (latency = ms.getMetric("latency")) != null) {
            return latency.getLongValue("count");
        }
        return 0L;
    }

    public void onProgress(RouteMetricSet metrics) {
        try {
            long timeNow = this.timer.milliTime();
            if (timeNow - this.lastVerboseProgress > 30000L) {
                this.output.println("\n");
                this.renderStatusText(metrics, this.output);
                this.lastVerboseProgress = timeNow;
            } else if (timeNow - this.lastProgressTime > 1000L) {
                this.output.print("\rSuccessfully sent " + this.getOkMessageCount(metrics) + " messages so far");
                this.lastProgressTime = timeNow;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void done(RouteMetricSet metrics) {
        try {
            this.output.println("\n");
            this.renderStatusText(metrics, this.output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class PrintVisitor
    extends MetricVisitor {
        final PrintStream out;
        final NumberFormat format;

        PrintVisitor(PrintStream out) {
            this.out = out;
            this.format = NumberFormat.getNumberInstance(Locale.US);
            this.format.setMaximumFractionDigits(2);
            this.format.setMinimumFractionDigits(2);
            this.format.setMinimumIntegerDigits(1);
            this.format.setParseIntegerOnly(false);
            this.format.setRoundingMode(RoundingMode.HALF_UP);
            this.format.setGroupingUsed(false);
        }

        public boolean visitMetricSet(MetricSet set, boolean autoGenerated) {
            if (set instanceof MessageTypeMetricSet && !set.getName().equals("total")) {
                Metric ignoredMetric;
                Metric m = set.getMetric("latency");
                Metric count = set.getMetric("count");
                Metric err = set.getMetric("errors.total");
                long okCount = 0L;
                long errCount = 0L;
                long ignored = 0L;
                long minLatency = 0L;
                long maxLatency = 0L;
                long avgLatency = 0L;
                if (m != null) {
                    minLatency = m.getLongValue("min");
                    maxLatency = m.getLongValue("max");
                    avgLatency = m.getLongValue("average");
                }
                if (count != null) {
                    okCount = count.getLongValue("count");
                }
                if ((ignoredMetric = set.getMetric("ignored")) != null) {
                    ignored = ignoredMetric.getLongValue("count");
                }
                if (err != null) {
                    errCount = err.getLongValue("count");
                }
                long timeSinceStart = ProgressPrinter.this.timer.milliTime() - ProgressPrinter.this.startTime;
                this.out.println(((MessageTypeMetricSet)set).getMessageName() + ":\tok: " + okCount + " msgs/sec: " + this.format.format((double)okCount * 1000.0 / (double)timeSinceStart) + " failed: " + errCount + " ignored: " + ignored + " latency(min, max, avg): " + minLatency + ", " + maxLatency + ", " + avgLatency);
            }
            return true;
        }
    }
}

