/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespafeeder;

import com.yahoo.clientmetrics.MessageTypeMetricSet;
import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.concurrent.Timer;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public class ProgressPrinter
implements RouteMetricSet.ProgressCallback {
    private long startTime = 0L;
    private long lastProgressTime = 0L;
    private long lastVerboseProgress = 0L;
    final Timer timer;
    final PrintStream output;
    final NumberFormat format = NumberFormat.getNumberInstance(Locale.US);

    public ProgressPrinter(Timer timer, PrintStream output) {
        this.format.setMaximumFractionDigits(2);
        this.format.setMinimumFractionDigits(2);
        this.format.setMinimumIntegerDigits(1);
        this.format.setParseIntegerOnly(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.format.setGroupingUsed(false);
        this.timer = timer;
        this.output = output;
        this.lastProgressTime = this.startTime = timer.milliTime();
        this.lastVerboseProgress = this.startTime;
    }

    private void printMetrics(PrintStream out, RouteMetricSet metrics) {
        for (MessageTypeMetricSet m : metrics.getMetrics().values()) {
            long timeSinceStart = this.timer.milliTime() - this.startTime;
            out.println(m.getMessageName() + ":\tok: " + m.count + " msgs/sec: " + this.format.format((double)m.count * 1000.0 / (double)timeSinceStart) + " failed: " + m.errorCount + " ignored: " + m.ignored + " latency(min, max, avg): " + m.latency_min + ", " + m.latency_max + ", " + m.latency_total / Long.max(1L, m.count));
        }
    }

    public static String getDashes(int count) {
        Object dashes = "";
        for (int i = 0; i < count; ++i) {
            dashes = (String)dashes + "-";
        }
        return dashes;
    }

    public synchronized void renderStatusText(RouteMetricSet metrics, PrintStream stream) {
        String headline = "Messages sent to vespa (route " + metrics.getRoute() + ") :";
        stream.println(headline);
        stream.println(ProgressPrinter.getDashes(headline.length()));
        this.printMetrics(stream, metrics);
    }

    public long getOkMessageCount(RouteMetricSet metrics) {
        long count = 0L;
        for (MessageTypeMetricSet m : metrics.getMetrics().values()) {
            count += m.count;
        }
        return count;
    }

    public void onProgress(RouteMetricSet metrics) {
        try {
            long timeNow = this.timer.milliTime();
            if (timeNow - this.lastVerboseProgress > 30000L) {
                this.output.println("\n");
                this.renderStatusText(metrics, this.output);
                this.lastVerboseProgress = timeNow;
            } else if (timeNow - this.lastProgressTime > 1000L) {
                this.output.print("\rSuccessfully sent " + this.getOkMessageCount(metrics) + " messages so far");
                this.lastProgressTime = timeNow;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void done(RouteMetricSet metrics) {
        try {
            this.output.println("\n");
            this.renderStatusText(metrics, this.output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

