/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaget;

import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.vespaclient.ClusterList;
import com.yahoo.vespaget.ClientParameters;
import com.yahoo.vespaget.CommandLineOptions;
import com.yahoo.vespaget.DocumentAccessFactory;
import com.yahoo.vespaget.DocumentRetriever;
import com.yahoo.vespaget.DocumentRetrieverException;

public class Main {
    public static void main(String[] args) {
        try {
            CommandLineOptions options = new CommandLineOptions();
            ClientParameters params = options.parseCommandLineArguments(args);
            if (params.help) {
                options.printHelp();
            } else {
                DocumentRetriever documentRetriever = Main.createDocumentRetriever(params);
                Main.addShutdownHook(documentRetriever);
                documentRetriever.retrieveDocuments();
            }
        }
        catch (IllegalArgumentException e) {
            System.err.printf("Failed to parse command line arguments: %s.\n", e.getMessage());
        }
        catch (DocumentRetrieverException e) {
            System.err.printf("Failed to retrieve documents: %s\n", e.getMessage());
        }
    }

    private static void addShutdownHook(DocumentRetriever documentRetriever) {
        Runtime.getRuntime().addShutdownHook(new Thread(documentRetriever::shutdown));
    }

    private static DocumentRetriever createDocumentRetriever(ClientParameters params) {
        return new DocumentRetriever(new ClusterList("client"), new DocumentAccessFactory(), new LoadTypeSet(params.configId), params);
    }
}

