/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespafeeder;

import com.yahoo.clientmetrics.MessageTypeMetricSet;
import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.concurrent.Timer;
import com.yahoo.metrics.Metric;
import com.yahoo.metrics.MetricSet;
import com.yahoo.metrics.MetricVisitor;
import java.io.PrintStream;

public class BenchmarkProgressPrinter
implements RouteMetricSet.ProgressCallback {
    private final long startTime;
    private final Timer timer;
    private final PrintStream output;

    public BenchmarkProgressPrinter(Timer timer, PrintStream output) {
        this.timer = timer;
        this.output = output;
        this.startTime = timer.milliTime();
    }

    public void onProgress(RouteMetricSet metrics) {
    }

    public void done(RouteMetricSet metrics) {
        try {
            this.output.println("# Time used, num ok, num error, min latency, max latency, average latency");
            metrics.visit((MetricVisitor)new PrintVisitor(this.output), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class PrintVisitor
    extends MetricVisitor {
        private final PrintStream out;

        PrintVisitor(PrintStream out) {
            this.out = out;
        }

        public boolean visitMetricSet(MetricSet set, boolean autoGenerated) {
            if (set instanceof MessageTypeMetricSet && set.getName().equals("total")) {
                Metric m = set.getMetric("latency");
                Metric count = set.getMetric("count");
                Metric err = set.getMetric("errors.total");
                long okCount = 0L;
                long errCount = 0L;
                long minLatency = 0L;
                long maxLatency = 0L;
                long avgLatency = 0L;
                if (m != null) {
                    minLatency = m.getLongValue("min");
                    maxLatency = m.getLongValue("max");
                    avgLatency = m.getLongValue("average");
                }
                if (count != null) {
                    okCount = count.getLongValue("count");
                }
                if (err != null) {
                    errCount = err.getLongValue("count");
                }
                long timeUsed = BenchmarkProgressPrinter.this.timer.milliTime() - BenchmarkProgressPrinter.this.startTime;
                this.out.println(timeUsed + ", " + okCount + ", " + errCount + ", " + minLatency + ", " + maxLatency + ", " + avgLatency);
            }
            return true;
        }
    }
}

