/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespafeeder;

import com.yahoo.feedapi.DummySessionFactory;
import com.yahoo.feedapi.MessageBusSessionFactory;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.config.FeederConfig;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Arguments {
    private FeederConfig.Builder feederConfigBuilder = new FeederConfig.Builder();
    private List<String> files = new ArrayList<String>();
    private String dumpDocumentsFile = null;
    private String mode = "standard";
    private boolean validateOnly = false;
    private boolean verbose = false;
    SessionFactory sessionFactory = null;
    MessagePropertyProcessor propertyProcessor = null;
    private String priority = null;

    public FeederConfig getFeederConfig() {
        return new FeederConfig(this.feederConfigBuilder);
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MessagePropertyProcessor getPropertyProcessor() {
        return this.propertyProcessor;
    }

    public void help() {
        System.out.println("This is a tool for feeding xml (deprecated) or json data to a Vespa application.\n\nThe options are:\n  --abortondataerror arg (true) Whether or not to abort if the xml input has \n                                errors (true|false).\n  --abortonsenderror arg (true) Whether or not to abort if an error occured while\n                                sending operations to Vespa (true|false).\n  --file arg                    The name of the input files to read. These can \n                                also be passed as arguments without the option \n                                prefix. If none is given, this tool parses \n                                identifiers from standard in.\n  -h [ --help ]                 Shows this help page.\n  --maxpending arg              The maximum number of operations that are allowed\n                                to be pending at any given time. NOTE: This disables dynamic throttling. Use with care.\n  --maxpendingsize arg          The maximum size (in bytes) of operations that \n                                are allowed to be pending at any given time. \n  --maxfeedrate arg             Limits the feed rate to the given number (operations/second). You may still want to increase\n                                the max pending size if your feed rate doesn't reach the desired number.\n  --mode arg (=standard)        The mode to run vespa-feeder in (standard | benchmark).\n  --noretry                     Turns off retries of recoverable failures.\n  --retrydelay arg (=1)         The time (in seconds) to wait between retries of \n                                a failed operation.\n  --route arg (=default)        The route to send the data to.\n  --timeout arg (=180)          The time (in seconds) allowed for sending \n                                operations.\n  --trace arg (=0)              The trace level of network traffic.\n  --validate                    Run validation tool on input files instead of \n                                feeding them.\n  --dumpDocuments <filename>    Specify a file where documents in the put are serialized.\n  --priority arg                Specify priority of sent messages (see documentation for priority values)\n  --create-if-non-existent      Enable setting of create-if-non-existent to true on all document updates in the given xml feed.\n  -v [ --verbose ]              Enable verbose output of progress.\n");
    }

    public Arguments(String[] argList, SessionFactory factory) throws HelpShownException, FileNotFoundException {
        this.parse(argList);
        if (factory != null) {
            this.sessionFactory = factory;
        } else if (this.validateOnly) {
            if (this.dumpDocumentsFile != null) {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.dumpDocumentsFile));
                this.sessionFactory = new DummySessionFactory(null, (OutputStream)out);
            } else {
                this.sessionFactory = new DummySessionFactory(null, null);
            }
        } else {
            this.sessionFactory = new MessageBusSessionFactory(this.propertyProcessor);
        }
    }

    void parse(String[] argList) throws HelpShownException {
        LinkedList<String> args = new LinkedList<String>();
        args.addAll(Arrays.asList(argList));
        while (!args.isEmpty()) {
            String arg = (String)args.remove(0);
            if (arg.equals("-h") || arg.equals("--help")) {
                this.help();
                throw new HelpShownException();
            }
            if ("--abortondataerror".equals(arg)) {
                this.feederConfigBuilder.abortondocumenterror(this.getBoolean(this.getParam(args, arg)).booleanValue());
                continue;
            }
            if ("--abortonsenderror".equals(arg)) {
                this.feederConfigBuilder.abortonsenderror(this.getBoolean(this.getParam(args, arg)).booleanValue());
                continue;
            }
            if ("--file".equals(arg)) {
                this.files.add(this.getParam(args, arg));
                continue;
            }
            if ("--maxpending".equals(arg)) {
                this.feederConfigBuilder.maxpendingdocs(Integer.parseInt(this.getParam(args, arg)));
                continue;
            }
            if ("--maxpendingsize".equals(arg)) {
                this.feederConfigBuilder.maxpendingbytes(Integer.parseInt(this.getParam(args, arg)));
                continue;
            }
            if ("--mode".equals(arg)) {
                this.mode = this.getParam(args, arg);
                continue;
            }
            if ("--noretry".equals(arg)) {
                this.feederConfigBuilder.retryenabled(false);
                continue;
            }
            if ("--retrydelay".equals(arg)) {
                this.feederConfigBuilder.retrydelay((double)Integer.parseInt(this.getParam(args, arg)));
                continue;
            }
            if ("--route".equals(arg)) {
                this.feederConfigBuilder.route(this.getParam(args, arg));
                continue;
            }
            if ("--timeout".equals(arg)) {
                this.feederConfigBuilder.timeout(Double.parseDouble(this.getParam(args, arg)));
                continue;
            }
            if ("--trace".equals(arg)) {
                this.feederConfigBuilder.tracelevel(Integer.parseInt(this.getParam(args, arg)));
                continue;
            }
            if ("--validate".equals(arg)) {
                this.validateOnly = true;
                continue;
            }
            if ("--dumpDocuments".equals(arg)) {
                this.dumpDocumentsFile = this.getParam(args, arg);
                continue;
            }
            if ("--maxfeedrate".equals(arg)) {
                this.feederConfigBuilder.maxfeedrate(Double.parseDouble(this.getParam(args, arg)));
                continue;
            }
            if ("--create-if-non-existent".equals(arg)) {
                this.feederConfigBuilder.createifnonexistent(true);
                continue;
            }
            if ("-v".equals(arg) || "--verbose".equals(arg)) {
                this.verbose = true;
                continue;
            }
            if ("--priority".equals(arg)) {
                this.priority = this.getParam(args, arg);
                continue;
            }
            this.files.add(arg);
        }
        this.propertyProcessor = new MessagePropertyProcessor(this.getFeederConfig(), new LoadTypeConfig(new LoadTypeConfig.Builder()));
    }

    private String getParam(List<String> args, String arg) throws IllegalArgumentException {
        try {
            return args.remove(0);
        }
        catch (Exception e) {
            System.err.println("--" + arg + " requires an argument");
            throw new IllegalArgumentException(arg);
        }
    }

    private Boolean getBoolean(String arg) {
        if (arg.equalsIgnoreCase("yes")) {
            return true;
        }
        if (arg.equalsIgnoreCase("no")) {
            return false;
        }
        return Boolean.parseBoolean(arg);
    }

    public String getPriority() {
        return this.priority;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public class HelpShownException
    extends Exception {
    }
}

