/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.KeyId;
import java.nio.ByteBuffer;
import java.util.Base64;

public record SealedSharedKey(KeyId keyId, byte[] enc, byte[] ciphertext) {
    public static final int CURRENT_TOKEN_VERSION = 1;
    public static final int MAX_ENC_CONTEXT_LENGTH = 255;

    public SealedSharedKey {
        if (enc.length > 255) {
            throw new IllegalArgumentException("Encryption context is too large to be encoded (max is %d, got %d)".formatted(255, enc.length));
        }
    }

    public String toTokenString() {
        byte[] keyIdBytes = this.keyId.asBytes();
        ByteBuffer encoded = ByteBuffer.allocate(2 + keyIdBytes.length + 1 + this.enc.length + this.ciphertext.length);
        encoded.put((byte)1);
        encoded.put((byte)keyIdBytes.length);
        encoded.put(keyIdBytes);
        encoded.put((byte)this.enc.length);
        encoded.put(this.enc);
        encoded.put(this.ciphertext);
        encoded.flip();
        byte[] encBytes = new byte[encoded.remaining()];
        encoded.get(encBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(encBytes);
    }

    public static SealedSharedKey fromTokenString(String tokenString) {
        byte[] rawTokenBytes = Base64.getUrlDecoder().decode(tokenString);
        if (rawTokenBytes.length < 1) {
            throw new IllegalArgumentException("Decoded token too small to contain a version");
        }
        ByteBuffer decoded = ByteBuffer.wrap(rawTokenBytes);
        int version = Byte.toUnsignedInt(decoded.get());
        if (version != 1) {
            throw new IllegalArgumentException("Token had unexpected version. Expected %d, was %d".formatted(1, version));
        }
        int keyIdLen = Byte.toUnsignedInt(decoded.get());
        byte[] keyIdBytes = new byte[keyIdLen];
        decoded.get(keyIdBytes);
        int encLen = Byte.toUnsignedInt(decoded.get());
        byte[] enc = new byte[encLen];
        decoded.get(enc);
        byte[] ciphertext = new byte[decoded.remaining()];
        decoded.get(ciphertext);
        return new SealedSharedKey(KeyId.ofBytes(keyIdBytes), enc, ciphertext);
    }

    public int tokenVersion() {
        return 1;
    }
}

