/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.HostGlobPattern;
import com.yahoo.security.tls.UriGlobPattern;
import java.util.Objects;

public class RequiredPeerCredential {
    private final Field field;
    private final Pattern pattern;

    private RequiredPeerCredential(Field field, Pattern pattern) {
        this.field = field;
        this.pattern = pattern;
    }

    public static RequiredPeerCredential of(Field field, String pattern) {
        return new RequiredPeerCredential(field, RequiredPeerCredential.createPattern(field, pattern));
    }

    private static Pattern createPattern(Field field, String pattern) {
        switch (field) {
            case CN: 
            case SAN_DNS: {
                return new HostGlobPattern(pattern);
            }
            case SAN_URI: {
                return new UriGlobPattern(pattern);
            }
        }
        throw new IllegalArgumentException("Unknown field: " + field);
    }

    public Field field() {
        return this.field;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public String toString() {
        return "RequiredPeerCredential{field=" + this.field + ", pattern=" + this.pattern + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredPeerCredential that = (RequiredPeerCredential)o;
        return this.field == that.field && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.pattern});
    }

    public static enum Field {
        CN,
        SAN_DNS,
        SAN_URI;

    }

    public static interface Pattern {
        public String asString();

        public boolean matches(String var1);
    }
}

