/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.KeyStoreBuilder;
import com.yahoo.security.KeyStoreType;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public class TrustManagerUtils {
    public static X509ExtendedTrustManager createDefaultX509TrustManager(KeyStore truststore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            return Arrays.stream(trustManagers).filter(manager -> manager instanceof X509ExtendedTrustManager).map(X509ExtendedTrustManager.class::cast).findFirst().orElseThrow(() -> new RuntimeException("No X509ExtendedTrustManager in " + List.of(trustManagers)));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509ExtendedTrustManager createDefaultX509TrustManager(List<X509Certificate> certificates) {
        return TrustManagerUtils.createDefaultX509TrustManager(KeyStoreBuilder.withType(KeyStoreType.PKCS12).withCertificateEntries("cert", certificates).build());
    }

    public static X509ExtendedTrustManager createDefaultX509TrustManager() {
        return TrustManagerUtils.createDefaultX509TrustManager((KeyStore)null);
    }
}

