/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.math.BigInteger;
import java.util.Arrays;

public class BaseNCodec {
    public static final int MAX_BASE = 255;
    private static final BigInteger BN_ZERO = BigInteger.valueOf(0L);
    private final Alphabet alphabet;
    private final BigInteger alphabetLenBN;

    private BaseNCodec(String alphabet) {
        this.alphabet = new Alphabet(alphabet);
        this.alphabetLenBN = BigInteger.valueOf(this.alphabet.alphabetChars.length);
    }

    public static BaseNCodec of(String alphabet) {
        return new BaseNCodec(alphabet);
    }

    public int base() {
        return this.alphabet.alphabetChars.length;
    }

    public String encode(byte[] input) {
        StringBuilder sb = new StringBuilder(input.length * 2);
        BigInteger num = new BigInteger(1, input);
        while (!num.equals(BN_ZERO)) {
            BigInteger[] quotRem = num.divideAndRemainder(this.alphabetLenBN);
            num = quotRem[0];
            sb.append(this.alphabet.alphabetChars[quotRem[1].intValue()]);
        }
        for (byte leadingByte : input) {
            if (leadingByte != 0) break;
            sb.append(this.alphabet.alphabetChars[0]);
        }
        return sb.reverse().toString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] decode(String input) {
        boolean msbZero;
        void var7_10;
        char[] inputChars = input.toCharArray();
        int prefixNulls = 0;
        for (char c : inputChars) {
            if (c != this.alphabet.alphabetChars[0]) break;
            ++prefixNulls;
        }
        BigInteger accu = BN_ZERO;
        char[] cArray = inputChars;
        int n = cArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            int idx;
            char c = cArray[var7_10];
            int n2 = idx = c < this.alphabet.reverseLut.length ? this.alphabet.reverseLut[c] : -1;
            if (idx == -1) {
                throw new IllegalArgumentException("Input character not part of codec alphabet");
            }
            accu = accu.multiply(this.alphabetLenBN).add(BigInteger.valueOf(idx));
            ++var7_10;
        }
        byte[] bnBytes = accu.toByteArray();
        boolean bl2 = msbZero = bnBytes[0] == 0;
        if (prefixNulls == 0 && !msbZero) {
            return bnBytes;
        }
        int n3 = msbZero ? bnBytes.length - 1 : bnBytes.length;
        byte[] result = new byte[prefixNulls + n3];
        System.arraycopy(bnBytes, msbZero ? 1 : 0, result, prefixNulls, n3);
        return result;
    }

    private static class Alphabet {
        final char[] alphabetChars;
        final int[] reverseLut;

        Alphabet(String alphabetIn) {
            if (alphabetIn.length() < 2) {
                throw new IllegalArgumentException("Alphabet requires at least two symbols");
            }
            if (alphabetIn.length() > 255) {
                throw new IllegalArgumentException("Alphabet size too large");
            }
            this.alphabetChars = alphabetIn.toCharArray();
            int highestChar = Integer.MIN_VALUE;
            for (char ch : this.alphabetChars) {
                highestChar = Math.max(highestChar, ch);
            }
            this.reverseLut = new int[highestChar + 1];
            Arrays.fill(this.reverseLut, -1);
            for (int i = 0; i < this.alphabetChars.length; ++i) {
                if (this.reverseLut[this.alphabetChars[i]] != -1) {
                    throw new IllegalArgumentException("Alphabet character '%c' occurs more than once".formatted(Character.valueOf(this.alphabetChars[i])));
                }
                this.reverseLut[this.alphabetChars[i]] = i;
            }
        }
    }
}

