/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.token;

import com.yahoo.security.ArrayUtils;
import com.yahoo.security.HKDF;
import com.yahoo.security.token.TokenDomain;
import com.yahoo.security.token.TokenFingerprint;
import java.util.Objects;

public class Token {
    private final TokenDomain domain;
    private final String secretTokenString;
    private final byte[] secretTokenBytes;
    private final TokenFingerprint fingerprint;

    Token(TokenDomain domain, String secretTokenString) {
        this.domain = domain;
        this.secretTokenString = secretTokenString;
        this.secretTokenBytes = ArrayUtils.toUtf8Bytes(secretTokenString);
        this.fingerprint = TokenFingerprint.of(this);
    }

    public static Token of(TokenDomain domain, String secretTokenString) {
        return new Token(domain, secretTokenString);
    }

    public TokenDomain domain() {
        return this.domain;
    }

    public String secretTokenString() {
        return this.secretTokenString;
    }

    public TokenFingerprint fingerprint() {
        return this.fingerprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.domain, token.domain) && Objects.equals(this.fingerprint, token.fingerprint);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.fingerprint);
    }

    public String toString() {
        return "Token(fingerprint: %s, domain: %s)".formatted(this.fingerprint, this.domain);
    }

    byte[] toDerivedBytes(int nHashBytes, byte[] domainSeparationContext) {
        HKDF hkdf = HKDF.unsaltedExtractedFrom(this.secretTokenBytes);
        return hkdf.expand(nHashBytes, domainSeparationContext);
    }
}

