/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.token;

import com.yahoo.security.ArrayUtils;
import com.yahoo.security.token.Token;
import java.util.Arrays;
import java.util.HexFormat;

public record TokenFingerprint(byte[] hashBytes) {
    public static final int FINGERPRINT_BITS = 128;
    public static final int FINGERPRINT_BYTES = 16;
    public static final byte[] FINGERPRINT_CONTEXT = ArrayUtils.toUtf8Bytes("Vespa token fingerprint");

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenFingerprint that = (TokenFingerprint)o;
        return Arrays.equals(this.hashBytes, that.hashBytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.hashBytes);
    }

    public String toHexString() {
        return ArrayUtils.hex(this.hashBytes);
    }

    public String toDelimitedHexString() {
        return HexFormat.ofDelimiter(":").formatHex(this.hashBytes);
    }

    @Override
    public String toString() {
        return this.toDelimitedHexString();
    }

    public static TokenFingerprint of(Token token) {
        return new TokenFingerprint(token.toDerivedBytes(16, FINGERPRINT_CONTEXT));
    }

    public static TokenFingerprint ofRawBytes(byte[] hashBytes) {
        return new TokenFingerprint(Arrays.copyOf(hashBytes, hashBytes.length));
    }

    public static TokenFingerprint ofHex(String hex) {
        HexFormat format = hex.contains(":") ? HexFormat.ofDelimiter(":") : HexFormat.of();
        return TokenFingerprint.ofRawBytes(format.parseHex(hex));
    }
}

