/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.authz;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class AuthorizationResult {
    private final Set<String> matchedPolicies;

    public AuthorizationResult(Set<String> matchedPolicies) {
        this.matchedPolicies = Collections.unmodifiableSet(matchedPolicies);
    }

    public Set<String> matchedPolicies() {
        return this.matchedPolicies;
    }

    public boolean succeeded() {
        return this.matchedPolicies.size() > 0;
    }

    public String toString() {
        return "AuthorizationResult{, matchedPolicies=" + this.matchedPolicies + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationResult that = (AuthorizationResult)o;
        return Objects.equals(this.matchedPolicies, that.matchedPolicies);
    }

    public int hashCode() {
        return Objects.hash(this.matchedPolicies);
    }
}

