/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import java.util.Arrays;

public enum Capability {
    CONTENT__CLUSTER_CONTROLLER__INTERNAL_STATE_API("vespa.content.cluster_controller.internal_state_api"),
    CONTENT__DOCUMENT_API("vespa.content.document_api"),
    CONTENT__METRICS_API("vespa.content.metrics_api"),
    CONTENT__SEARCH_API("vespa.content.search_api"),
    CONTENT__STATUS_PAGES("vespa.content.status_pages"),
    CONTENT__STORAGE_API("vespa.content.storage_api"),
    SLOBROK__API("vespa.slobrok.api");

    private final String name;

    private Capability(String name) {
        this.name = name;
    }

    public String asString() {
        return this.name;
    }

    public static Capability fromName(String name) {
        return Arrays.stream(Capability.values()).filter(c -> c.name.equals(name)).findAny().orElseThrow(() -> new IllegalArgumentException("Cannot find predefined capability set with name '" + name + "'"));
    }
}

