/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import com.yahoo.security.tls.policy.PeerPolicy;
import java.util.Set;

public record AuthorizedPeers(Set<PeerPolicy> peerPolicies) {
    public AuthorizedPeers {
        peerPolicies = AuthorizedPeers.verifyPeerPolicies(peerPolicies);
    }

    private static Set<PeerPolicy> verifyPeerPolicies(Set<PeerPolicy> peerPolicies) {
        long distinctNames = peerPolicies.stream().map(PeerPolicy::policyName).distinct().count();
        if (distinctNames != (long)peerPolicies.size()) {
            throw new IllegalArgumentException("'authorized-peers' contains entries with duplicate names");
        }
        return Set.copyOf(peerPolicies);
    }
}

