/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import com.yahoo.security.tls.policy.RequiredPeerCredential;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PeerPolicy {
    private final String policyName;
    private final String description;
    private final List<RequiredPeerCredential> requiredCredentials;

    public PeerPolicy(String policyName, List<RequiredPeerCredential> requiredCredentials) {
        this(policyName, null, requiredCredentials);
    }

    public PeerPolicy(String policyName, String description, List<RequiredPeerCredential> requiredCredentials) {
        this.policyName = policyName;
        this.description = description;
        this.requiredCredentials = Collections.unmodifiableList(requiredCredentials);
    }

    public String policyName() {
        return this.policyName;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public List<RequiredPeerCredential> requiredCredentials() {
        return this.requiredCredentials;
    }

    public String toString() {
        return "PeerPolicy{policyName='" + this.policyName + "', description='" + this.description + "', requiredCredentials=" + this.requiredCredentials + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerPolicy that = (PeerPolicy)o;
        return Objects.equals(this.policyName, that.policyName) && Objects.equals(this.description, that.description) && Objects.equals(this.requiredCredentials, that.requiredCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.policyName, this.description, this.requiredCredentials);
    }
}

