/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.SubjectAlternativeName;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.AuthorizedPeers;
import com.yahoo.security.tls.CapabilityMode;
import com.yahoo.security.tls.CapabilitySet;
import com.yahoo.security.tls.ConnectionAuthContext;
import com.yahoo.security.tls.PeerPolicy;
import com.yahoo.security.tls.RequiredPeerCredential;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class PeerAuthorizer {
    private static final Logger log = Logger.getLogger(PeerAuthorizer.class.getName());
    private final AuthorizedPeers authorizedPeers;

    public PeerAuthorizer(AuthorizedPeers authorizedPeers) {
        this.authorizedPeers = authorizedPeers;
    }

    public ConnectionAuthContext authorizePeer(X509Certificate cert) {
        return this.authorizePeer(List.of(cert));
    }

    public ConnectionAuthContext authorizePeer(List<X509Certificate> certChain) {
        if (this.authorizedPeers.isEmpty()) {
            return ConnectionAuthContext.defaultAllCapabilities(certChain);
        }
        X509Certificate cert = certChain.get(0);
        HashSet<String> matchedPolicies = new HashSet<String>();
        HashSet<CapabilitySet> grantedCapabilities = new HashSet<CapabilitySet>();
        String cn = X509CertificateUtils.getSubjectCommonName(cert).orElse(null);
        List<String> sans = PeerAuthorizer.getSubjectAlternativeNames(cert);
        log.fine(() -> String.format("Subject info from x509 certificate: CN=[%s], 'SAN=%s", cn, sans));
        for (PeerPolicy peerPolicy : this.authorizedPeers.peerPolicies()) {
            if (!PeerAuthorizer.matchesPolicy(peerPolicy, cn, sans)) continue;
            matchedPolicies.add(peerPolicy.policyName());
            grantedCapabilities.add(peerPolicy.capabilities());
        }
        CapabilityMode capabilityMode = TransportSecurityUtils.getCapabilityMode();
        return new ConnectionAuthContext(certChain, CapabilitySet.unionOf(grantedCapabilities), matchedPolicies, capabilityMode);
    }

    private static boolean matchesPolicy(PeerPolicy peerPolicy, String cn, List<String> sans) {
        return peerPolicy.requiredCredentials().stream().allMatch(requiredCredential -> PeerAuthorizer.matchesRequiredCredentials(requiredCredential, cn, sans));
    }

    private static boolean matchesRequiredCredentials(RequiredPeerCredential requiredCredential, String cn, List<String> sans) {
        switch (requiredCredential.field()) {
            case CN: {
                return cn != null && requiredCredential.pattern().matches(cn);
            }
            case SAN_DNS: 
            case SAN_URI: {
                return sans.stream().anyMatch(san -> requiredCredential.pattern().matches((String)san));
            }
        }
        throw new RuntimeException("Unknown field: " + requiredCredential.field());
    }

    private static List<String> getSubjectAlternativeNames(X509Certificate peerCertificate) {
        return X509CertificateUtils.getSubjectAlternativeNames(peerCertificate).stream().filter(san -> san.getType() == SubjectAlternativeName.Type.DNS || san.getType() == SubjectAlternativeName.Type.IP || san.getType() == SubjectAlternativeName.Type.URI).map(SubjectAlternativeName::getValue).toList();
    }
}

