/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class SubjectAlternativeName {
    private final Type type;
    private final String value;

    public SubjectAlternativeName(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    SubjectAlternativeName(GeneralName bcGeneralName) {
        this.type = Type.fromTag(bcGeneralName.getTagNo());
        this.value = this.getValue(bcGeneralName);
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    GeneralName toGeneralName() {
        return new GeneralName(this.type.tag, this.value);
    }

    static List<SubjectAlternativeName> fromGeneralNames(GeneralNames generalNames) {
        return Arrays.stream(generalNames.getNames()).map(SubjectAlternativeName::new).collect(Collectors.toList());
    }

    private String getValue(GeneralName bcGeneralName) {
        ASN1Encodable name = bcGeneralName.getName();
        switch (bcGeneralName.getTagNo()) {
            case 1: 
            case 2: 
            case 6: {
                return DERIA5String.getInstance((Object)name).getString();
            }
            case 4: {
                return X500Name.getInstance((Object)name).toString();
            }
        }
        return name.toString();
    }

    public String toString() {
        return "SubjectAlternativeName{type=" + this.type + ", value='" + this.value + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectAlternativeName that = (SubjectAlternativeName)o;
        return this.type == that.type && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public static enum Type {
        OTHER_NAME(0),
        RFC822_NAME(1),
        DNS_NAME(2),
        X400_ADDRESS(3),
        DIRECTORY_NAME(4),
        EDI_PARITY_NAME(5),
        UNIFORM_RESOURCE_IDENTIFIER(6),
        IP_ADDRESS(7),
        REGISTERED_ID(8);

        final int tag;

        private Type(int tag) {
            this.tag = tag;
        }

        public static Type fromTag(int tag) {
            return Arrays.stream(Type.values()).filter(type -> type.tag == tag).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid tag: " + tag));
        }

        public int getTag() {
            return this.tag;
        }
    }
}

