/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import com.yahoo.security.tls.policy.PeerPolicy;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class AuthorizedPeers {
    private final Set<PeerPolicy> peerPolicies;

    public AuthorizedPeers(Set<PeerPolicy> peerPolicies) {
        this.peerPolicies = this.verifyPeerPolicies(peerPolicies);
    }

    private Set<PeerPolicy> verifyPeerPolicies(Set<PeerPolicy> peerPolicies) {
        long distinctNames = peerPolicies.stream().map(PeerPolicy::policyName).distinct().count();
        if (distinctNames != (long)peerPolicies.size()) {
            throw new IllegalArgumentException("'authorized-peers' contains entries with duplicate names");
        }
        return Collections.unmodifiableSet(peerPolicies);
    }

    public Set<PeerPolicy> peerPolicies() {
        return this.peerPolicies;
    }

    public String toString() {
        return "AuthorizedPeers{peerPolicies=" + this.peerPolicies + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizedPeers that = (AuthorizedPeers)o;
        return Objects.equals(this.peerPolicies, that.peerPolicies);
    }

    public int hashCode() {
        return Objects.hash(this.peerPolicies);
    }
}

