/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.Pkcs10Csr;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class Pkcs10CsrUtils {
    private Pkcs10CsrUtils() {
    }

    public static Pkcs10Csr fromPem(String pem) {
        Pkcs10Csr pkcs10Csr;
        PEMParser pemParser = new PEMParser((Reader)new StringReader(pem));
        try {
            pkcs10Csr = new Pkcs10Csr((PKCS10CertificationRequest)pemParser.readObject());
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemParser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        pemParser.close();
        return pkcs10Csr;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toPem(Pkcs10Csr csr) {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
                pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE REQUEST", csr.getBcCsr().getEncoded()));
                pemWriter.flush();
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

