/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.KeyStoreBuilder;
import com.yahoo.security.KeyStoreType;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.MutableX509KeyManager;
import com.yahoo.security.tls.MutableX509TrustManager;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.vespa.jdk8compat.Files;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.security.KeyStore;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class TlsManager {
    private static final Logger log = Logger.getLogger(TlsManager.class.getName());
    private static final Duration UPDATE_PERIOD = Duration.ofHours(1L);
    private final Path tlsConfigFile;
    private final MutableX509TrustManager trustManager;
    private final MutableX509KeyManager keyManager;
    private final ScheduledExecutorService scheduler;
    private TransportSecurityOptions options;
    private final AtomicInteger references = new AtomicInteger(0);

    private static void reloadTrustManager(TransportSecurityOptions options, MutableX509TrustManager trustManager) {
        if (options.getCaCertificatesFile().isPresent()) {
            trustManager.updateTruststore(TlsManager.loadTruststore(options.getCaCertificatesFile().get()));
        } else {
            trustManager.useDefaultTruststore();
        }
    }

    private static void reloadKeyManager(TransportSecurityOptions options, MutableX509KeyManager keyManager) {
        if (options.getPrivateKeyFile().isPresent() && options.getCertificatesFile().isPresent()) {
            keyManager.updateKeystore(TlsManager.loadKeystore(options.getPrivateKeyFile().get(), options.getCertificatesFile().get()), new char[0]);
        } else {
            keyManager.useDefaultKeystore();
        }
    }

    private static KeyStore loadTruststore(Path caCertificateFile) {
        try {
            return KeyStoreBuilder.withType(KeyStoreType.PKCS12).withCertificateEntries("cert", X509CertificateUtils.certificateListFromPem(Files.readString(caCertificateFile))).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static KeyStore loadKeystore(Path privateKeyFile, Path certificatesFile) {
        try {
            return KeyStoreBuilder.withType(KeyStoreType.PKCS12).withKeyEntry("default", KeyUtils.fromPemEncodedPrivateKey(Files.readString(privateKeyFile)), X509CertificateUtils.certificateListFromPem(Files.readString(certificatesFile))).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    TlsManager(Path tlsOptionsConfigFile) {
        this.tlsConfigFile = tlsOptionsConfigFile;
        this.trustManager = new MutableX509TrustManager();
        this.keyManager = new MutableX509KeyManager();
        this.options = TransportSecurityOptions.fromJsonFile(tlsOptionsConfigFile);
        TlsManager.reloadTrustManager(this.options, this.trustManager);
        TlsManager.reloadKeyManager(this.options, this.keyManager);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ReloaderThreadFactory(tlsOptionsConfigFile));
        this.scheduler.scheduleAtFixedRate(new CryptoMaterialReloader(tlsOptionsConfigFile, this.scheduler, this), UPDATE_PERIOD.getSeconds(), UPDATE_PERIOD.getSeconds(), TimeUnit.SECONDS);
    }

    MutableX509TrustManager getTrustManager() {
        return this.trustManager;
    }

    MutableX509KeyManager getKeyManager() {
        return this.keyManager;
    }

    Path getTlsConfigFile() {
        return this.tlsConfigFile;
    }

    TransportSecurityOptions getOptions() {
        return this.options;
    }

    void close() {
        this.scheduler.shutdown();
    }

    int addRef() {
        return this.references.incrementAndGet();
    }

    int subRef() {
        return this.references.decrementAndGet();
    }

    private static class ReloaderThreadFactory
    implements ThreadFactory {
        Path fileName;

        ReloaderThreadFactory(Path fileName) {
            this.fileName = fileName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "tls-context-reloader:" + this.fileName.toString());
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class CryptoMaterialReloader
    implements Runnable {
        private final Path tlsOptionsConfigFile;
        private final ScheduledExecutorService scheduler;
        private final WeakReference<TlsManager> tlsManager;

        CryptoMaterialReloader(Path tlsOptionsConfigFile, ScheduledExecutorService scheduler, TlsManager tlsManager) {
            this.tlsOptionsConfigFile = tlsOptionsConfigFile;
            this.scheduler = scheduler;
            this.tlsManager = new WeakReference<TlsManager>(tlsManager);
        }

        @Override
        public void run() {
            try {
                TlsManager tlsManager = (TlsManager)this.tlsManager.get();
                if (tlsManager == null) {
                    this.scheduler.shutdown();
                    return;
                }
                TransportSecurityOptions options = TransportSecurityOptions.fromJsonFile(this.tlsOptionsConfigFile);
                TlsManager.reloadTrustManager(options, tlsManager.getTrustManager());
                TlsManager.reloadKeyManager(options, tlsManager.getKeyManager());
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, String.format("Failed to reload crypto material (path='%s'): %s", this.tlsOptionsConfigFile, t.getMessage()), t);
            }
        }
    }
}

