/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.DefaultTlsContext;
import com.yahoo.security.tls.TlsContext;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class ReloadingTlsContext
implements TlsContext {
    private static final Duration UPDATE_PERIOD = Duration.ofHours(1L);
    private static final Logger log = Logger.getLogger(ReloadingTlsContext.class.getName());
    private final Path tlsOptionsConfigFile;
    private final AuthorizationMode mode;
    private final AtomicReference<TlsContext> currentTlsContext;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "tls-context-reloader");
        thread.setDaemon(true);
        return thread;
    });

    public ReloadingTlsContext(Path tlsOptionsConfigFile, AuthorizationMode mode) {
        this.tlsOptionsConfigFile = tlsOptionsConfigFile;
        this.mode = mode;
        this.currentTlsContext = new AtomicReference<DefaultTlsContext>(new DefaultTlsContext(tlsOptionsConfigFile, mode));
        this.scheduler.scheduleAtFixedRate(new SslContextReloader(), UPDATE_PERIOD.getSeconds(), UPDATE_PERIOD.getSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public SSLEngine createSslEngine() {
        return this.currentTlsContext.get().createSslEngine();
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdownNow();
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class SslContextReloader
    implements Runnable {
        private SslContextReloader() {
        }

        @Override
        public void run() {
            try {
                ReloadingTlsContext.this.currentTlsContext.set(new DefaultTlsContext(ReloadingTlsContext.this.tlsOptionsConfigFile, ReloadingTlsContext.this.mode));
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, String.format("Failed to load SSLContext (path='%s'): %s", ReloadingTlsContext.this.tlsOptionsConfigFile, t.getMessage()), t);
            }
        }
    }
}

