/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.BouncyCastleProviderHolder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;

public enum KeyStoreType {
    JKS{

        @Override
        KeyStore createKeystore() throws KeyStoreException {
            return KeyStore.getInstance("JKS");
        }
    }
    ,
    PKCS12{

        @Override
        KeyStore createKeystore() throws KeyStoreException {
            return KeyStore.getInstance("PKCS12", (Provider)BouncyCastleProviderHolder.getInstance());
        }
    };


    abstract KeyStore createKeystore() throws GeneralSecurityException;
}

