/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree.rankingexpression;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.parser.rankingexpression.Node;
import ai.vespa.schemals.parser.rankingexpression.TokenSource;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.io.PrintStream;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class RankingExpressionUtils {
    private static Position getPositionFromOffset(TokenSource tokenSource, int offset) {
        int line = tokenSource.getLineFromOffset(offset) - 1;
        int startOfLineOffset = tokenSource.getLineStartOffset(line + 1);
        int column = offset - startOfLineOffset;
        return new Position(line, column);
    }

    public static Range getRangeFromOffsets(TokenSource tokenSource, int beginOffset, int endOffset) {
        Position begin = RankingExpressionUtils.getPositionFromOffset(tokenSource, beginOffset);
        Position end = RankingExpressionUtils.getPositionFromOffset(tokenSource, endOffset);
        return new Range(begin, end);
    }

    public static Range getNodeRange(Node node) {
        TokenSource tokenSource = node.getTokenSource();
        return RankingExpressionUtils.getRangeFromOffsets(tokenSource, node.getBeginOffset(), node.getEndOffset());
    }

    public static void printTree(ClientLogger logger, Node node) {
        RankingExpressionUtils.printTree(logger, node, (Integer)0);
    }

    public static void printTree(ClientLogger logger, Node node, Integer indent) {
        Range range = RankingExpressionUtils.getNodeRange(node);
        logger.info(new String(new char[indent.intValue()]).replace("\u0000", "\t") + node.getClass().getName() + ": (" + range.getStart().getLine() + ", " + range.getStart().getCharacter() + ") - (" + range.getEnd().getLine() + ", " + range.getEnd().getCharacter() + ")");
        for (Node child : node) {
            RankingExpressionUtils.printTree(logger, child, (Integer)(indent + 1));
        }
    }

    public static void printTree(ClientLogger logger, RankNode node) {
        RankingExpressionUtils.printTree(logger, node, 0);
    }

    public static void printTree(ClientLogger logger, RankNode node, int indent) {
        logger.info(new String(new char[indent]).replace("\u0000", "\t") + node.toString());
        for (RankNode child : node) {
            RankingExpressionUtils.printTree(logger, child, indent + 1);
        }
    }

    public static void printExpressionTree(PrintStream logger, ExpressionNode node, int indent) {
        String className = node.getClass().getSimpleName();
        String msg = node.toString() + " (" + className + ")";
        if (node instanceof ReferenceNode) {
            Reference ref = ((ReferenceNode)node).reference();
            msg = msg + " [REF: " + ref.name() + "]";
            if (ref.isIdentifier()) {
                msg = msg + " [IDENTIFIER]";
            }
            if (ref.output() != null) {
                msg = msg + " [OUTPUT: " + ref.output() + "]";
            }
        }
        logger.println(new String(new char[indent]).replaceAll("\u0000", "\t") + msg);
        if (node instanceof CompositeNode) {
            for (ExpressionNode child : ((CompositeNode)node).children()) {
                RankingExpressionUtils.printExpressionTree(logger, child, indent + 1);
            }
        }
    }
}

