/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.formatting;

import ai.vespa.schemals.context.EventFormattingContext;
import ai.vespa.schemals.context.EventRangeFormattingContext;
import ai.vespa.schemals.lsp.schema.formatting.FormattingUtils;
import ai.vespa.schemals.parser.ast.LBRACE;
import ai.vespa.schemals.parser.ast.NL;
import ai.vespa.schemals.parser.ast.RBRACE;
import ai.vespa.schemals.parser.ast.Root;
import ai.vespa.schemals.parser.ast.openLbrace;
import ai.vespa.schemals.parser.ast.rootDocument;
import ai.vespa.schemals.parser.ast.rootSchema;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class SchemaFormatting {
    public static List<TextEdit> computeFormattingEdits(EventFormattingContext context) {
        SchemaNode root2 = context.document.getRootNode();
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        FormattingUtils.FormatPositionInformation info = new FormattingUtils.FormatPositionInformation(0, true, Optional.empty());
        FormattingOptions options = context.getOptions();
        SchemaFormatting.formatTraverse(result, root2, info, options);
        if (options.isTrimTrailingWhitespace()) {
            SchemaFormatting.computeTrimTrailingWhitespaceEdits(result, context.document.getCurrentContent());
        }
        if (context.getOptions().isTrimFinalNewlines()) {
            SchemaFormatting.computeTrimFinalNewlinesEdits(result, root2, options.isInsertFinalNewline());
        }
        return result;
    }

    public static List<TextEdit> computeRangeFormattingEdits(EventRangeFormattingContext context) {
        SchemaNode root2 = context.document.getRootNode();
        FormattingUtils.LineRange range = new FormattingUtils.LineRange(context.getRange().getStart().getLine(), context.getRange().getEnd().getLine());
        ArrayList<Node> nodesInRange = new ArrayList<Node>();
        FormattingOptions options = context.getOptions();
        FormattingUtils.findNodesInLineRange(root2, range, nodesInRange);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        for (Node node : nodesInRange) {
            Node containing = FormattingUtils.getFirstLbraceAncestor(node);
            int indentLevel = 0;
            if (containing != null) {
                indentLevel = FormattingUtils.computeNodeIndentLevel(containing, options);
                if (!node.isASTInstance(openLbrace.class)) {
                    ++indentLevel;
                }
            }
            SchemaFormatting.formatTraverse(edits, node, new FormattingUtils.FormatPositionInformation(indentLevel, true, Optional.of(range)), options);
        }
        return edits;
    }

    private static void formatTraverse(List<TextEdit> edits, Node node, FormattingUtils.FormatPositionInformation info, FormattingOptions options) {
        if (!node.isSchemaNode()) {
            return;
        }
        if (node.getLanguageType() != Node.LanguageType.SCHEMA) {
            return;
        }
        if (info.formatRange().isPresent()) {
            int nodeFirstLine = node.getRange().getStart().getLine();
            int nodeLastLine = node.getRange().getEnd().getLine();
            if (info.formatRange().get().lastLine() < nodeFirstLine || nodeLastLine < info.formatRange().get().firstLine()) {
                return;
            }
        }
        if (node.isASTInstance(NL.class)) {
            return;
        }
        if (info.nodeStartsLine()) {
            SchemaFormatting.formatLineStartNodePosition(edits, node, info, options);
        } else {
            SchemaFormatting.formatLineMiddleNodePosition(edits, node);
        }
        int lbraceIndex = FormattingUtils.getNodeLbraceIndex(node);
        if (lbraceIndex != -1) {
            SchemaFormatting.formatLbracePosition(edits, node.get(lbraceIndex));
        }
        int lastNonNLIndex = -1;
        for (int i = 0; i < node.size(); ++i) {
            boolean childStartsNewLine;
            Node child = node.get(i);
            int indentLevel = info.indentLevel();
            boolean bl = childStartsNewLine = lbraceIndex != -1 && i > lbraceIndex;
            if (childStartsNewLine) {
                ++indentLevel;
            }
            if (child.isASTInstance(rootSchema.class) || child.isASTInstance(rootDocument.class)) {
                childStartsNewLine = true;
            }
            if (child.isASTInstance(RBRACE.class) && lastNonNLIndex == lbraceIndex && node.get(lbraceIndex).size() <= 2) {
                childStartsNewLine = false;
            }
            SchemaFormatting.formatTraverse(edits, child, new FormattingUtils.FormatPositionInformation(indentLevel, childStartsNewLine, info.formatRange()), options);
            if (child.isASTInstance(NL.class)) continue;
            lastNonNLIndex = i;
        }
    }

    private static void formatLineStartNodePosition(List<TextEdit> edits, Node node, FormattingUtils.FormatPositionInformation info, FormattingOptions options) {
        Node shouldBeNL;
        if (node.isASTInstance(Root.class)) {
            return;
        }
        if (FormattingUtils.isEOF(node)) {
            return;
        }
        int indentLevel = info.indentLevel();
        if (node.isASTInstance(RBRACE.class)) {
            --indentLevel;
        }
        String indentationString = FormattingUtils.createIndentationString(indentLevel, options);
        if (node.getPreviousSibling() != null && !(shouldBeNL = node.getPreviousSibling().findLastLeaf()).isASTInstance(NL.class)) {
            edits.add(new TextEdit(new Range(shouldBeNL.getRange().getEnd(), node.getRange().getStart()), "\n" + indentationString));
            return;
        }
        Range range = new Range(new Position(node.getRange().getStart().getLine(), 0), node.getRange().getStart());
        edits.add(new TextEdit(range, indentationString));
    }

    private static void formatLineMiddleNodePosition(List<TextEdit> edits, Node node) {
        Node prev;
        if (node.getPreviousSibling() == null) {
            return;
        }
        if (node.getASTClass() == null) {
            return;
        }
        if (node.isASTInstance(LBRACE.class)) {
            return;
        }
        if (node.isASTInstance(openLbrace.class)) {
            return;
        }
        for (prev = node.getPreviousSibling(); prev != null && (prev.isASTInstance(NL.class) || CSTUtils.rangeIsEmpty(prev.getRange())); prev = prev.getPreviousSibling()) {
        }
        if (prev == null) {
            return;
        }
        String insertText = "";
        if (FormattingUtils.shouldHaveSpaceBetween(prev, node)) {
            insertText = " ";
        }
        Range range = new Range(prev.getRange().getEnd(), node.getRange().getStart());
        if (prev.isASTInstance(openLbrace.class) && node.getRange().getStart().getLine() - prev.getRange().getStart().getLine() <= 1) {
            Position lbracePos = prev.getRange().getStart();
            range = new Range(new Position(lbracePos.getLine(), lbracePos.getCharacter() + 1), node.getRange().getStart());
        }
        edits.add(new TextEdit(range, insertText));
    }

    private static void formatLbracePosition(List<TextEdit> edits, Node lbraceNode) {
        Node nodeBeforeLbrace = lbraceNode.getPreviousSibling();
        while (nodeBeforeLbrace.isASTInstance(NL.class)) {
            nodeBeforeLbrace = nodeBeforeLbrace.getPreviousSibling();
        }
        Node LBRACENode = lbraceNode.get(0);
        while (!LBRACENode.isASTInstance(LBRACE.class)) {
            LBRACENode = LBRACENode.getNextSibling();
        }
        edits.add(new TextEdit(new Range(nodeBeforeLbrace.getRange().getEnd(), LBRACENode.getRange().getStart()), " "));
    }

    private static void computeTrimTrailingWhitespaceEdits(List<TextEdit> edits, String documentContent) {
        int prevNewLine = -1;
        int nextNewLine = documentContent.indexOf(10);
        int lineNum = 0;
        while (true) {
            int ptr;
            if (nextNewLine == -1) {
                nextNewLine = documentContent.length();
            }
            for (ptr = nextNewLine - 1; ptr > 0 && documentContent.codePointAt(ptr) != 10 && Character.isWhitespace(documentContent.codePointAt(ptr)); --ptr) {
            }
            if (ptr < nextNewLine) {
                edits.add(new TextEdit(new Range(new Position(lineNum, ptr - prevNewLine), new Position(lineNum, nextNewLine - prevNewLine)), ""));
            }
            if (nextNewLine == documentContent.length()) break;
            prevNewLine = nextNewLine;
            nextNewLine = documentContent.indexOf(10, nextNewLine + 1);
            ++lineNum;
        }
    }

    private static void computeTrimFinalNewlinesEdits(List<TextEdit> edits, Node root2, boolean insertOne) {
        if (root2.size() == 0) {
            return;
        }
        Node EOFNode = null;
        Node lastRBRACENode = null;
        if (root2.get(0).isASTInstance(rootSchema.class)) {
            root2 = root2.get(0);
            EOFNode = root2.get(root2.size() - 1);
            lastRBRACENode = EOFNode.getPreviousSibling();
        } else {
            EOFNode = root2.get(root2.size() - 1);
            root2 = root2.get(0);
            lastRBRACENode = root2.get(root2.size() - 1);
        }
        while (lastRBRACENode != null && !lastRBRACENode.isASTInstance(RBRACE.class)) {
            lastRBRACENode = lastRBRACENode.getPreviousSibling();
        }
        if (EOFNode == null || lastRBRACENode == null) {
            return;
        }
        String insertString = insertOne ? "\n" : "";
        Range range = new Range(lastRBRACENode.getRange().getEnd(), EOFNode.getRange().getStart());
        edits.add(new TextEdit(range, insertString));
    }
}

