/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command.commandtypes;

import ai.vespa.schemals.context.EventExecuteCommandContext;
import ai.vespa.schemals.lsp.common.command.CommandUtils;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;

public class SetupWorkspace
implements SchemaCommand {
    URI baseURI;

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public boolean setArguments(List<Object> arguments2) {
        assert (arguments2.size() == this.getArity());
        Optional<String> argument2 = CommandUtils.getStringArgument(arguments2.get(0));
        if (argument2.isEmpty()) {
            return false;
        }
        String suppliedURI = argument2.get();
        try {
            Path schemasPath = Paths.get(new URI(suppliedURI)).getParent().resolve("schemas");
            if (schemasPath.toFile().exists()) {
                this.baseURI = schemasPath.toUri();
            }
        }
        catch (URISyntaxException exception) {
            return false;
        }
        return true;
    }

    @Override
    public Object execute(EventExecuteCommandContext context) {
        if (context.scheduler.getWorkspaceURI() == null && this.baseURI != null) {
            context.scheduler.setupWorkspace(this.baseURI);
        }
        return null;
    }
}

