/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.documentsymbols;

import ai.vespa.schemals.context.EventDocumentContext;
import ai.vespa.schemals.index.Symbol;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SchemaDocumentSymbols {
    private static SymbolKind schemaSymbolTypeToLSPSymbolKind(Symbol.SymbolType type) {
        switch (type) {
            case FIELD: 
            case STRUCT_FIELD: 
            case SUBFIELD: {
                return SymbolKind.Field;
            }
            case STRUCT: {
                return SymbolKind.Struct;
            }
            case SCHEMA: {
                return SymbolKind.Namespace;
            }
            case DOCUMENT: {
                return SymbolKind.Class;
            }
            case FUNCTION: 
            case LAMBDA_FUNCTION: {
                return SymbolKind.Function;
            }
            case PARAMETER: {
                return SymbolKind.Variable;
            }
            case RANK_PROFILE: {
                return SymbolKind.Method;
            }
        }
        return SymbolKind.Property;
    }

    private static Range getSymbolRange(Symbol symbol) {
        if (symbol.getNode().getParent() == null) {
            return symbol.getNode().getRange();
        }
        if (symbol.getType() == Symbol.SymbolType.PARAMETER) {
            return symbol.getNode().getRange();
        }
        return symbol.getNode().getParent().getRange();
    }

    public static List<Either<SymbolInformation, DocumentSymbol>> documentSymbols(EventDocumentContext context) {
        List<Symbol> allSymbols = context.schemaIndex.listSymbolsInScope(null, EnumSet.allOf(Symbol.SymbolType.class));
        HashMap<Symbol, DocumentSymbol> symbols = new HashMap<Symbol, DocumentSymbol>();
        for (Symbol symbol : allSymbols) {
            if (!symbol.fileURIEquals(context.document.getFileURI()) || symbol.getShortIdentifier() == null || symbol.getShortIdentifier().isBlank()) continue;
            symbols.put(symbol, new DocumentSymbol(symbol.getShortIdentifier(), SchemaDocumentSymbols.schemaSymbolTypeToLSPSymbolKind(symbol.getType()), SchemaDocumentSymbols.getSymbolRange(symbol), symbol.getNode().getRange(), symbol.getPrettyIdentifier(), new ArrayList()));
        }
        for (Map.Entry entry : symbols.entrySet()) {
            Symbol child = (Symbol)entry.getKey();
            Symbol parent = child.getScope();
            if (parent == null || !symbols.containsKey(parent)) continue;
            ((DocumentSymbol)symbols.get(parent)).getChildren().add((DocumentSymbol)entry.getValue());
        }
        ArrayList<Either<SymbolInformation, DocumentSymbol>> result = new ArrayList<Either<SymbolInformation, DocumentSymbol>>();
        for (Map.Entry entry : symbols.entrySet()) {
            if (((Symbol)entry.getKey()).getScope() != null && symbols.containsKey(((Symbol)entry.getKey()).getScope())) continue;
            result.add((Either<SymbolInformation, DocumentSymbol>)Either.forRight((Object)((DocumentSymbol)entry.getValue())));
        }
        return result;
    }
}

