## services

| Attribute | Required | Value  | Default |         Description          |
|-----------|----------|--------|---------|------------------------------|
| version   | required | number |         | 1.0 in this version of Vespa |

Optional subelements (one or more of *container* , *content* or *service* is required):

* [`admin`](https://docs.vespa.ai/en/reference/services-admin.html)
* [`content`](https://docs.vespa.ai/en/reference/services-content.html)
* [`container`](https://docs.vespa.ai/en/reference/services-container.html)
* [`routing`](https://docs.vespa.ai/en/operations-selfhosted/routing.html#routing-services)

Example:

```
<?xml version="1.0" encoding="utf-8" ?>
<services version="1.0">
  <container version="1.0" id="container">
    <search/>
    <document-api/>
    <nodes>
      <node hostalias="node0"/>
    </nodes>
  </container>
  <content id="music" version="1.0">
    <redundancy>2</redundancy>
    <nodes>
      <node hostalias="node0"/>
      <node hostalias="node1"/>
    </nodes>
    <documents>
      <document type="music"/>
    </documents>
  </content>
</services>
```

[Read more](https://docs.vespa.ai/en/reference/services.html#services)
