## searcher

Searcher elements are contained in [chain](https://docs.vespa.ai/en/reference/services-search.html#chain) elements or in the [search]() root.

A searcher element is either a *definition* (using *id* ) or a *reference* (using *idref*).

A searcher definition causes the creation of exactly one searcher instance. This instance is set up according to the content of the searcher element. A searcher definition contained in a search chain element defines an *inner searcher* . Otherwise, it defines an *outer searcher.*

Searcher definition:

| Attribute | Required | Value  | Default |                                                                                                                                     Description                                                                                                                                     |
|-----------|----------|--------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| id        | required | string |         | The component id of the searcher instance. For inner searchers, the id must be unique inside the search chain. For outer searchers, the id must be unique. An inner searcher is not permitted to have the same id as an outer searcher.                                             |
| class     | optional |        |         | A component specification containing the name of the class to instantiate to create the searcher instance. If missing, copied from id                                                                                                                                               |
| bundle    | optional |        |         | A component specification containing the bundle symbolic name and version used to select the bundle: The name in \<artifactId\> in pom.xml. The class is loaded from this bundle. If no bundle is specified, it defaults to the bundle containing the searchers bundled with Vespa. |
| provides  | optional |        |         | A space-separated list of names that represents what this searcher produces. For more information on provides, before and after, see [chained components](https://docs.vespa.ai/en/components/chained-components.html)                                                              |
| before    | optional |        |         | A space-separated list of phase or provided names. Phases or searchers providing these names will be placed later in the search chain than this searcher                                                                                                                            |
| after     | optional |        |         | A space-separated list of phase or provided names. Phases or searchers providing these names will be placed earlier in the search chain than this searcher                                                                                                                          |

Example:

```
<searcher id="componentId"
          class="className:versionSpecification"
          bundle="the name in <artifactId> in pom.xml" />
```

Searcher reference:

| Attribute | Required | Value  | Default |            Description             |
|-----------|----------|--------|---------|------------------------------------|
| idref     | required | string |         | Reference to a searcher definition |

Example:

```
<searcher idref="componentId" />
```

[Read more](https://docs.vespa.ai/en/reference/services-search.html#searcher)
