## federationoptions

Contained in [source](https://docs.vespa.ai/en/reference/services-search.html#source) or [provider](https://docs.vespa.ai/en/reference/services-search.html#provider). Specifies *how* a federation searcher should federate to a given search chain. If a federation options A *overrides* another federation options B, the result is a new federation options containing:

* all the options in B not present in A
* all the options in A

When federating to a source or provider, the federation searcher per default uses the federation options from the search chain. If a [source reference](https://docs.vespa.ai/en/reference/services-search.html#source-reference) contains federation options, it overrides the options of the search chain when used from the enclosing federation searcher.

|   Attribute    | Required |   Value    | Default |                                                                                                                                                                                                                      Description                                                                                                                                                                                                                       |
|----------------|----------|------------|---------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| timeout        | optional | number     |         | The minimum number of seconds or milliseconds (if ms is present) the federation searcher waits for the federated search chain executing the query                                                                                                                                                                                                                                                                                                      |
| requestTimeout | optional | number     |         | The minimum number of seconds or milliseconds (if ms is present) the search chain executing the query should continue execution. In some cases it is useful to set this higher than the timeout, such that a chain can keep waiting for requested data longer than the query is waiting for the chain. This allows queries to populate caches within the search chain even though populating the caches requires waiting longer than the query timeout |
| optional       | optional | true/false | false   | Determines if the federation searcher should wait for this search chain at all. Normally, it only waits for mandatory (i.e. not optional) search chains, and when they are done, cancels the remaining search chains that are not finished. If all the search chains federated to are optional, all of them will be treated as mandatory. All search chains are per default mandatory                                                                  |

Example:

```
<federationoptions timeout="2.0" requestTimeout="2500ms" optional="true" />
```

[Read more](https://docs.vespa.ai/en/reference/services-search.html#federationoptions)
