## document-api

Use to enable [Document API](https://docs.vespa.ai/en/api.html) operations to a container cluster. Children elements:

|          Name           | Required |   Value    |  Default   |                                                                                                                                                                                                                                                                                                                          Description                                                                                                                                                                                                                                                                                                                           |
|-------------------------|----------|------------|------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| binding                 | optional | string     | http://\*/ | The URI to map the document-api handlers to. Multiple bindings are valid. Must end with a '/'. Note that each document-api handler will get its individual binding by adding a suffix, e.g. the feed handler will add 'feed/', the remove handler will add 'remove/' and so on. Example: ``` <document-api> <binding>http://*/document-api/</binding> <binding>https://*/document-api/</binding> </document-api> ``` With these configured bindings, the feed handler will be available at `http://*/document-api/feed/` and `https://*/document-api/feed/`. For other handlers, just replace 'feed/' with the appropriate suffix, e.g. 'get/', 'remove/' etc. |
| abortondocumenterror    | optional | true/false | true       | Controls whether to abort the entire feed or not if a document-related error occurs, i.e. if a document contains an unknown field. Setting this field to `true` will abort the feed on such errors, while setting it to `false` will cause Vespa to simply skip to the next document in the feed. Note that malformed XML in the input will abort the feed regardless of this setting.                                                                                                                                                                                                                                                                         |
| maxpendingbytes         | optional | number     |            | The maximum number of pending bytes. If `<maxpendingdocs>` is 0 and this is set to 0, this defaults to 100 MB. If `<maxpendingdocs>` is more than 0, and this is set to 0, the send-window is only limited by number of messages sent, not the memory footprint.                                                                                                                                                                                                                                                                                                                                                                                               |
| maxpendingdocs          | optional | number     |            | The maximum number of pending documents the client can have. By default, the client will dynamically adjust the window size based on the latency of the performed operations. If the parameter is set, dynamic window sizing will be turned off in favor of the configured value.                                                                                                                                                                                                                                                                                                                                                                              |
| mbusport                | optional | number     |            | Set the MessageBus port                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| retrydelay              | optional | double     | 1.0        | Delay in seconds between retries                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| retryenabled            | optional | true/false |            | Enable or disable retrying documents that have failed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| route                   | optional | string     | default    | Set the route to feed documents to                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| timeout                 | optional | double     | 180.0      | Set the timeout value in seconds for an operation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| tracelevel              | optional | 0-9        | 0          | Configure the level of which to trace messages sent. The higher the level, the more detailed descriptions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| ignore-undefined-fields | optional | true/false | false      | Set to true to ignore undefined fields in document API operations and let such operations complete successfully, rather than fail. A [response header is returned](https://docs.vespa.ai/en/reference/document-v1-api-reference.html#x-vespa-ignored-fields) when field operations are ignored.                                                                                                                                                                                                                                                                                                                                                                |

Example:

```
<document-api>
    <binding>http://*/document-api/</binding>
    <binding>https://*/document-api/</binding>
    <abortondocumenterror>false</abortondocumenterror>
    <maxpendingbytes>1048576</maxpendingbytes>
    <maxpendingdocs>1000</maxpendingdocs>
    <mbusport>1234</mbusport>
    <retrydelay>5.5</retrydelay>
    <retryenabled>false</retryenabled>
    <route>default</route>
    <timeout>250.5</timeout>
    <tracelevel>3</tracelevel>
<document-api>
```

[Read more](https://docs.vespa.ai/en/reference/services-container.html#document-api)
