## metric

Configure a metric.

| Attribute | Required | Value  | Default |                                                                   Description                                                                   |
|-----------|----------|--------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------|
| id        | required | string |         | The name of the metric as defined in custom code or in [process metrics api](https://docs.vespa.ai/en/reference/state-v1.html#state-v1-metrics) |

Note that metric id needs to include the metric specific suffix, e.g. *.average*.

In this example, there is one metric added to a custom consumer in addition to the default metric set. Use *\&consumer=my-custom-consumer* parameter for the prometheus endpoint. Also notice the .count suffix, see [process metrics api](https://docs.vespa.ai/en/reference/state-v1.html#state-v1-metrics).

The per process metrics api endpoint */state/v1/metrics* also includes a description of each emitted metric. The */state/v1/metrics* endpoint also includes the metric aggregates (.count, .average, .rate, .max).


```xml
<metrics>
    <consumer id="my-custom-consumer">
        <metric-set id="default" />
        <metric id="vds.idealstate.garbage_collection.documents_removed.count" />
    </consumer>
</metrics>

```


[Read more](https://docs.vespa.ai/en/reference/services-admin.html#metric)
