## rank-profile

Contained in [schema](https://docs.vespa.ai/en/reference/schema-reference.html#schema) or equivalently in separate files in the [application package](https://docs.vespa.ai/en/reference/application-packages-reference.html), named `[profile-name].profile` in any directory below `schemas/[schema-name]/`. A [rank profile](https://docs.vespa.ai/en/ranking.html#rank-profiles) is a named set of ranking expression functions and settings which can be [selected in the query](https://docs.vespa.ai/en/reference/query-api-reference.html#ranking.profile)).

Whether defined inline in the schema or in a separate .profile file, the syntax of a rank profile is

```
rank-profile [name] inherits [rank-profile1], [rank-profile2], ...  {
    [body]
}
```

The `inherits` list is optional and may contain the name of other rank profiles in this schema or one it inherits. Elements not defined in this rank profile will then be inherited from those profiles. Inheriting multiple profiles which define the same elements leads to an error at deployment.

The body of a rank-profile may contain:

|                                             Name                                              |  Occurrence  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|-----------------------------------------------------------------------------------------------|--------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [diversity](https://docs.vespa.ai/en/reference/schema-reference.html#diversity)               | Zero or one  | Specification of required diversity between the different phases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [strict](https://docs.vespa.ai/en/reference/schema-reference.html#strict)                     | Zero or one  | true/false: Whether to use strict or loose type checking.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [match-phase](https://docs.vespa.ai/en/reference/schema-reference.html#match-phase)           | Zero or one  | Ranking configuration to be used for hit limitation during matching.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [first-phase](https://docs.vespa.ai/en/reference/schema-reference.html#firstphase-rank)       | Zero or one  | The ranking config to be used for first-phase ranking.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [second-phase](https://docs.vespa.ai/en/reference/schema-reference.html#secondphase-rank)     | Zero or one  | The ranking config to be used for second-phase ranking.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [global-phase](https://docs.vespa.ai/en/reference/schema-reference.html#globalphase-rank)     | Zero or one  | The ranking config to be used for global-phase ranking.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [function \[name\]](https://docs.vespa.ai/en/reference/schema-reference.html#function-rank)   | Zero or more | Defines a named function that can be referenced during ranking phase(s) and (if without arguments) as part of match-and summary-features.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [inputs](https://docs.vespa.ai/en/reference/schema-reference.html#inputs)                     | Zero or many | List of query features used in ranking expressions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [constants](https://docs.vespa.ai/en/reference/schema-reference.html#constants)               | Zero or many | List of constant features available in ranking expressions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [mutate](https://docs.vespa.ai/en/reference/schema-reference.html#mutate)                     | Zero or many | Specification of mutations you can apply after different phases of a query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [onnx-model](https://docs.vespa.ai/en/reference/schema-reference.html#onnx-model)             | Zero or many | An onnx model to make available in this profile.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [significance](https://docs.vespa.ai/en/reference/schema-reference.html#significance)         | Zero or one  | To enable the use of significance models defined in the service.xml config.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [rank-properties](https://docs.vespa.ai/en/reference/schema-reference.html#rank-properties)   | Zero or one  | List of any rank property key-values to be used by rank features.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [match-features](https://docs.vespa.ai/en/reference/schema-reference.html#match-features)     | Zero or more | The [rank features](https://docs.vespa.ai/en/reference/rank-features.html) to be returned with each hit, computed in the *match* phase.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [summary-features](https://docs.vespa.ai/en/reference/schema-reference.html#summary-features) | Zero or more | The [rank features](https://docs.vespa.ai/en/reference/rank-features.html) to be returned with each hit, computed in the *fill* phase.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [rank-features](https://docs.vespa.ai/en/reference/schema-reference.html#rank-features)       | Zero or more | The [rank features](https://docs.vespa.ai/en/reference/rank-features.html) to be dumped when using the query-argument [rankfeatures](https://docs.vespa.ai/en/reference/query-api-reference.html#ranking.listfeatures).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| ignore-default-rank-features                                                                  | Zero or one  | Do not dump the default set of rank features, only those explicitly specified with the [rank-features](https://docs.vespa.ai/en/reference/schema-reference.html#rank-features) command.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| num-threads-per-search                                                                        | Zero or one  | Overrides the global [persearch](https://docs.vespa.ai/en/reference/services-content.html#requestthreads-persearch) threads to a **lower** value.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| min-hits-per-thread                                                                           | Zero or one  | After estimating number of hits for a query prior to query evaluation, this number is used to decide how many threads to use for the query. `num_treads = min(`[num-threads-per-search](https://docs.vespa.ai/en/reference/schema-reference.html#num-threads-per-search)`, estimated_hits / min-hits-per-thread)` Current default is 1. If you suspect the fixed cost per thread is too high increasing this number might be a good idea. Especially if most of your queries are cheap, but you have increased the [num-threads-per-search](https://docs.vespa.ai/en/reference/schema-reference.html#num-threads-per-search) in order to reduce latency for your costly queries covering a lot of documents. The default might change, or the optimal value might be adaptive rendering overrides ignored or counterproductive.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| num-search-partitions                                                                         | Zero or one  | Number of logical partitions the corpus on a searchnode is divided in. By default, this is the same as [num-threads-per-search](https://docs.vespa.ai/en/reference/schema-reference.html#num-threads-per-search). A partition is the smallest unit a search thread will handle. If you have a locality in time when searching and feeding documents, you might want to split it into more, smaller partitions. That way you avoid that one costly partition leaves some threads idle while others are working hard. If you have 8 threads per search, you might have 10x as many partitions at 80 reducing max skew with a similar factor. Note that a value of zero turns on adaptive partitioning which tries to solve this optimally. **Note:** If `num-search-partitions` is set to 0 (work sharing is enabled), make sure `termwise-limit` is set to 1.0 (termwise evaluation is disabled). This is to avoid redoing termwise evaluation when work is passed from one thread to another. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| termwise-limit                                                                                | Zero or one  | If estimated number of hits \> corpus \* termwise-limit, it will prune candidates with a cpu cache friendly [TAAT](https://docs.vespa.ai/en/performance/feature-tuning.html#hybrid-taat-daat) with the terms not needed for ranking, prior to doing [DAAT](https://docs.vespa.ai/en/performance/feature-tuning.html#hybrid-taat-daat). Current default is 1.0 which turns it off. A value between 0.05 and 0.20 can be a good starting point. This is particularly useful if you have many weak filters. Note that this is a manual override. The default might change, or the optimal value might be adaptive rendering overrides ignored or counterproductive.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| post-filter-threshold                                                                         | Zero or one  | Threshold value (in the range \[0.0, 1.0\]) deciding if a query with an approximate [nearestNeighbor](https://docs.vespa.ai/en/reference/query-language-reference.html#nearestneighbor) operator combined with filters is evaluated using post-filtering instead of the default pre-filtering. Post-filtering is chosen when the estimated filter hit ratio of the query is *larger* than this threshold. The default value is 1.0, which disables post-filtering. See [Controlling the filtering behavior with approximate nearest neighbor search](https://blog.vespa.ai/constrained-approximate-nearest-neighbor-search/#controlling-the-filtering-behavior-with-approximate-nearest-neighbor-search) for more details. With post-filtering the [targetHits](https://docs.vespa.ai/en/reference/query-language-reference.html#targethits) value used when searching the HNSW index is auto-adjusted in an effort to expose *targetHits* hits to first-phase ranking after post-filtering has been applied. The following formula is used: ``` adjustedTargetHits = min(targetHits / estimatedFilterHitRatio, targetHits * targetHitsMaxAdjustmentFactor). ``` Use [target-hits-max-adjustment-factor](https://docs.vespa.ai/en/reference/schema-reference.html#target-hits-max-adjustment-factor) to control the upper bound of the adjusted *targetHits* . <br /> This parameter has no effect in [streaming search](https://docs.vespa.ai/en/streaming-search.html#differences-in-streaming-search). |
| approximate-threshold                                                                         | Zero or one  | Threshold value (in the range \[0.0, 1.0\]) deciding if a query with an approximate [nearestNeighbor](https://docs.vespa.ai/en/reference/query-language-reference.html#nearestneighbor) operator combined with filters is evaluated by searching the [HNSW](https://docs.vespa.ai/en/reference/schema-reference.html#index-hnsw) graph for approximate neighbors with pre-filtering, or performing an [exact nearest neighbor search](https://docs.vespa.ai/en/nearest-neighbor-search.html) with pre-filtering. The fallback to exact search is chosen when the estimated filter hit ratio of the query is *less* than this threshold. The default value is 0.05. See [Controlling the filtering behavior with approximate nearest neighbor search](https://blog.vespa.ai/constrained-approximate-nearest-neighbor-search/#controlling-the-filtering-behavior-with-approximate-nearest-neighbor-search) for more details. This parameter has no effect in [streaming search](https://docs.vespa.ai/en/streaming-search.html#differences-in-streaming-search).                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| target-hits-max-adjustment-factor                                                             | Zero or one  | Value (in the range \[1.0, inf\]) used to control the auto-adjustment of [targetHits](https://docs.vespa.ai/en/reference/query-language-reference.html#targethits) used when evaluating an approximate [nearestNeighbor](https://docs.vespa.ai/en/reference/query-language-reference.html#nearestneighbor) operator with post-filtering. The default value is 20.0. <br /> Setting this value to 1.0 disables auto-adjustment of *targetHits* . See [post-filter-threshold](https://docs.vespa.ai/en/reference/schema-reference.html#post-filter-threshold) for more details. This parameter no effect in [streaming search](https://docs.vespa.ai/en/streaming-search.html#differences-in-streaming-search).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [rank](https://docs.vespa.ai/en/reference/schema-reference.html#rank)                         | Zero or more | Specify if the field is used for ranking.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [rank-type](https://docs.vespa.ai/en/reference/schema-reference.html#rank-type)               | Zero or more | The rank-type of a field in this profile.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |

[Read more](https://docs.vespa.ai/en/reference/schema-reference.html#rank-profile)
